block('p-clients').elem('aux-actions').def()(function() {
    var data = this.data,
        ulogin = data.FORM.ulogin || data.user_login,
        isAgencyViewOwnRep = this.pageParams.isAgencyViewOwnRep,
        uidUrl = data.uid_url,
        uidParam = {},
        manager,
        chief,
        managerFIO = data.manager_FIO,
        managerEmail = data.manager_email,
        chiefAgency = data.chief_agency,
        duplicateLinks = {
            commander: {
                block: 'link',
                url: u.formatUrl({
                    protocol: 'https',
                    host: 'direct.' + data.yandex_domain,
                    path: '/commander/'
                }),
                content: iget2('p-clients', 'kommander', 'Коммандер')
            },
            api: {
                block: 'link',
                url: u.getUrl('apiSettings', ulogin ? { ulogin: u.escapeHTML(ulogin) } : null),
                content: iget2('p-clients', 'api', 'API')
            }
        },
        groups = [],
        groupsIdx = {},
        groupsNames = {
            stat: iget2('p-clients', 'statistika', 'Статистика'),
            inventory: iget2('p-clients', 'inventory', 'Инвентарь'),
            management: iget2('p-clients', 'upravlenie-kampaniyami', 'Управление кампаниями'),
            payments: iget2('p-clients', 'byudzhet-i-oplata', 'Бюджет и оплата'),
            additional: iget2('p-clients', 'dopolnitelnye-vozmozhnosti', 'Дополнительные возможности'),
            'agency-management': iget2('p-clients', 'upravlenie-klientami', 'Управление клиентами')

        },
        getOrCreateGroupObject = function(index) {
            var groupObj = groupsIdx[index] !== undefined ? groups[groupsIdx[index]] : {};

            if (groupsIdx[index] === undefined) {
                groupObj.title = groupsNames[index];
                groupObj.links = [];
                groups.push(groupObj);
                groupsIdx[index] = groups.length - 1;
            }

            return groupObj;
        },
        addLink = function(groupName, linkObj) {
            var groupObj = getOrCreateGroupObject(groupName);

            groupObj.links.push(linkObj);
        };

    uidUrl && (uidParam[uidUrl.key] = uidUrl.value) || (uidParam = '');

    if (!isAgencyViewOwnRep) {
        data.no_arch_users_exists > 1 &&
            !hasLoginRights('manager_control', 'superreader_control', 'media_control', 'support_control',
                'limited_support_control', 'agency_disallow_money_transfer') &&
            addLink('payments', {
                block: 'link',
                url: u.getUrl('transferStepZero', uidParam),
                content: iget2('p-clients', 'perenos-sredstv', 'Перенос средств')
            });
    }

    hasLoginRights('super_control') && !!data.show_mass_convert_link && addLink('payments', {
        block: 'link',
        url: u.getUrl('massMoveToRealMoney', {
            ulogin: u.escapeHTML(ulogin)
        }),
        content: iget2('p-clients', 'perevod-vseh-klientov-agentstva', 'Перевод всех клиентов агентства в валюту платежа')
    });

    hasLoginRights('super_control', 'manager_control', 'agency_control', 'superreader_control') &&
        addLink('stat', {
            block: 'link',
            url: u.getUrl('showCampStat', this.extend({
                stat_type: 'by_agency_clients'
            }, uidParam)),
            content: isAgencyViewOwnRep ?
                iget2('p-clients', 'statistika-po-klientam-predstavitelya', 'Статистика по клиентам представителя агентства') : iget2('p-clients', 'statistika-po-klientam-agentstva', 'Статистика по клиентам агентства')
        });

    addLink('agency-management', {
        block: 'link',
        url: u.getUrl('showSubClientCamps', hasLoginRights('agency_control') ? null : {
            ulogin: u.escapeHTML(ulogin)
        }),
        content: hasLoginRights('manager_control') ?
            iget2('p-clients', 'vse-kampanii-vseh-subklientov', 'Все кампании всех субклиентов моего агентства') : iget2('p-clients', 'vse-kampanii-moih-subklientov', 'Все кампании моих субклиентов')
    });

    !hasLoginRights('manager_control', 'super_control') && hasLoginRights('agency_control') && !isAgencyViewOwnRep &&
        addLink('agency-management', {
            block: 'link',
            url: u.getUrl('showRegisterLoginPage'),
            content: iget2('p-clients', 'registraciya-novogo-logina', 'Регистрация нового логина')
        });

    hasLoginRights('super_control', 'manager_control', 'superreader_control', 'support_control', 'limited_support_control') &&
        addLink('agency-management', {
            block: 'link',
            url: u.getUrl('showAgReps', uidParam),
            content: iget2('p-clients', 'predstaviteli-agentstva', 'Представители агентства')
        });

    hasLoginRights('super_control') && addLink('agency-management', {
        block: 'link',
        url: u.getUrl('addAgencyClientRelation', {
            ulogin: u.escapeHTML(ulogin)
        }),
        content: iget2('p-clients', 'dobavit-klienta', 'Добавить клиента')
    });

    if (hasLoginRights('agency_control') && !isAgencyViewOwnRep) {
        addLink('management', duplicateLinks.commander);

        data.api_enabled_flag && hasLoginRights('superreader_control') ||
            addLink('management', duplicateLinks.api);

        addLink('stat', {
            block: 'link',
            url: u.getUrl('listWarnPlace', this.extend({
                sort: 'addtime',
                reverse: 1,
                ws_place: 0,
                ws_time: '1d',
                ws_cid: 0,
                ws_done: 0
            }, u.consts('isMy') ? {} : { ws_client: ulogin })),
            content: iget2('p-clients', 'monitoring-izmeneniy-poziciy-po', 'Мониторинг изменений позиций по фразам')
        });

        data.login_rights.AllowMassADVQ && addLink('additional', {
            block: 'link',
            url: u.getUrl('allowMassADVQ'),
            content: iget2('p-clients', 'uvelichit-limit-zaprosov-v', 'Увеличить лимит запросов в «подборе слов»')
        });

        managerEmail && managerFIO && (manager = {
            name: managerFIO,
            email: managerEmail
        });

        chiefAgency && (chief = {
            name: chiefAgency.login,
            email: chiefAgency.email
        });
    }

    hasLoginRights('super_control', 'manager_control', 'superreader_control', 'support_control', 'limited_support_control') &&
        addLink('stat', {
            block: 'link',
            url: u.getUrl('listWarnPlace', this.extend({
                sort: 'addtime',
                reverse: 1,
                ws_place: 0,
                ws_time: '1d',
                ws_cid: 0,
                ws_done: 0
            }, uidParam)),
            content: iget2('p-clients', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам')
        });

    hasLoginRights('super_control', 'support_control') &&
        addLink('management', duplicateLinks.api);
    hasLoginRights('agency_control') ||
        addLink('management', duplicateLinks.commander);

    (hasLoginRights('super_control') || hasEnabledFeatures('cpm_deals') && !hasLoginRights('is_agency_limited')) && addLink('inventory', {
        block: 'link',
        url: u.formatUrl({
            path: '/dna/deals',
            query: {
                ulogin: u.consts('ulogin')
            }
        }),
        content: iget2('p-clients', 'inventory-deals', 'Список сделок')
    });

    hasLoginRights('super_control', 'superreader_control', 'manager_control', 'support_control', 'limited_support_control', 'agency_control') &&
        addLink('stat', {
            block: 'link',
            url: u.formatUrl({
                path: '/dna/offline-reports/',
                query: this.extend({
                    ulogin: ulogin
                }, uidParam)
            }),
            content: [
                iget2('p-clients', 'offline-reports-for-managers', 'Отчёт по клиентам'),
                {
                    block: 'b-beta',
                    mods: { type: 'symbol' }
                }
            ]
        });

    hasEnabledFeatures('billing_order_domains_offline_report_enabled') &&
    addLink('stat', {
        block: 'link',
        url: u.formatUrl({
            path: '/dna/domains-reports/',
            query: this.extend({
                ulogin: ulogin
            }, uidParam)
        }),
        content: [
            iget2('p-clients', 'domain-reports-for-managers', 'Отчёт по доменам'),
            {
                block: 'b-beta',
                mods: { type: 'symbol' }
            }
        ]
    });

    hasLoginRights('super_control', 'superreader_control', 'manager_control', 'support_control', 'limited_support_control', 'agency_control') &&
        u.hasOperatorFeature('agency_kpi_offline_report_enabled') &&
        addLink('stat', {
            block: 'link',
            url: u.formatUrl({
                path: '/dna/kpi-reports/',
                query: this.extend({
                    ulogin: ulogin
                }, uidParam)
            }),
            content: [
                iget2('p-clients', 'kpi-reports-for-managers', 'Отчёт по квартальным KPI'),
                {
                    block: 'b-beta',
                    mods: { type: 'symbol' }
                }
            ]
        });

    return [
        {
            block: 'b-additional-actions',
            mods: {
                bordered: 'yes'
            },
            groups: this.pageParams.showAux ? groups : undefined,
            chief: this.pageParams.showAux ? chief : undefined,
            manager: this.pageParams.showAux ? manager : undefined,
            footnotes: this.pageParams.superSubclientPresent || this.pageParams.superRightsToSscPresent ? [
                this.pageParams.superSubclientPresent ?
                    {
                        footnoteNo: '1',
                        text: iget2('p-clients', 'klient-s-pravami-upravleniya', 'Клиент с правами управления')
                    } :
                    undefined,
                this.pageParams.superRightsToSscPresent ?
                    {
                        footnoteNo: '2',
                        text: iget2('p-clients', 'klient-s-pravami-upravleniya-130', 'Клиент с правами управления, импорта из XLS-файла')
                    } :
                    undefined
            ] : undefined
        }
    ];
});
