block('p-clients').elem('header')(

    replace()(function() {
        return [{
            block: 'b-page-title',
            mix: [{
                block: 'p-clients',
                elem: 'header'
            }],
            title: apply('title-page'),
            text: this.data.FORM.advq_allowed ? iget2('p-clients', 'limit-zaprosov-v-podbore', 'Лимит запросов в "подборе слов" увеличен') : ''
        }];
    }),

    mode('title-page')(function() {
        return [this.pageParams.title];
    }),

    mode('title-page')(function() {
        var result = applyNext();

        if (hasLoginRights('super_control', 'manager_control', 'support_control', 'limited_support_control') ||
            (hasLoginRights('agency_control') && !u.consts('isMy'))) {

            result.push(apply('to-link'));

            hasLoginRights('is_internal_user') && result.push({
                block: 'p-clients',
                elem: 'header-client-id',
                content: apply('clientId')
            });
        } else if (hasLoginRights('superreader_control', 'media_control', 'placer_control')) {
            result.push(apply('client'));
        }

        return u.spacer(result);
    }),

    mode('to-link')(function() {
        var data = this.data,
            ulogin = data.FORM.ulogin;

        return {
            block: 'link',
            url: u.getUrl('modifyUser', {
                rulogin: ulogin,
                ulogin: ulogin,
                rcmd: 'showClients'
            }),
            content: apply('client')
        };
    }),

    mode('clientId')(function() {
        var agencyClientId = this.data.agency_client_id;

        return [
            ' ClientID ',
            {
                block: 'link',
                url: u.formatUrl({
                    host: u.consts('balance_admin'),
                    path: 'clients.xml',
                    query: {
                        client_id: agencyClientId
                    }
                }),
                content: agencyClientId
            }
        ];
    }),

    mode('client')(function() {
        var data = this.data;

        return u.escapeHTML(data.agency_FIO) + ' (' + data.FORM.ulogin + ')';
    })
);
