block('p-clients').elem('tabs').replace()(function() {
    var data = this.data,
        rights = data.login_rights,
        links = [];

    if (!this.pageParams.isAgencyViewOwnRep) {
        rights.agency_control && links.push({
            block: 'link',
            mods: {
                type: 'action'
            },
            url: u.formatUrl({
                host: u.consts('balance'),
                path: 'invoices.xml',
                query: {
                    service_cc: 'PPC',
                    ref_service_id: 7
                }
            }),
            content: iget2('p-clients', 'platezhi', 'Платежи')
        });

        links.push({
            block: 'link',
            mods: {
                type: 'action'
            },
            url: data.FORM.ulogin ?
                u.getUrl('clientDescriptions', {
                    ulogin: data.FORM.ulogin
                }) : u.getUrl('clientDescriptions'),
            content: iget2('p-clients', 'pokazat-vse-primechaniya', 'Показать все примечания')
        });
    }

    return {
        block: 'b-list-tabs',
        mods: {
            theme: 'border-bottom'
        },
        tabs: {
            keys: ['active', 'arch'],
            countItems: {
                active: data.no_arch_users_exists,
                arch: data.arch_users_exists
            }
        },
        links: links
    };
});
