match(function() {
    return this.data.cmd === 'showClients';
})(

    block('app-main').mode('page-block')('p-clients'),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            var data = this.data,
                title,
                isAgencyViewOwnRep = hasLoginRights('agency_control') && !u.consts('isMy'),
                clients = data.subclients || [],
                superRightsToSscPresent = 0,
                superSubclientPresent = 0;

            if (hasLoginRights('super_control', 'superreader_control', 'media_control', 'support_control', 'limited_support_control') ||
                (!hasLoginRights('manager_control') && hasLoginRights('placer_control')) ||
                (hasLoginRights('manager_control') && data.is_manager_foreign_agency)) {

                title = iget2('p-clients', 'klienty-agentstva', 'Клиенты агентства');
            } else if (hasLoginRights('manager_control')) {
                title = iget2('p-clients', 'klienty-moego-agentstva', 'Клиенты моего агентства');
            } else if (isAgencyViewOwnRep) {
                title = iget2('p-clients', 'klienty-predstavitelya', 'Клиенты представителя');
            } else {
                title = iget2('p-clients', 'moi-klienty', 'Мои клиенты');
            }

            //сноски внизу страницы
            for (var i in clients) {
                var client = clients[i];

                !superRightsToSscPresent && client.is_SuperRightsToSSC && (superRightsToSscPresent = 1);
                !superSubclientPresent && client.is_super_subclient && (superSubclientPresent = 1);

                if (superRightsToSscPresent && superSubclientPresent) break;
            }

            return applyNext({
                pageParams: {
                    title: title,
                    showAux: hasLoginRights(
                        'super_control',
                        'manager_control',
                        'agency_control',
                        'superreader_control',
                        'support_control',
                        'limited_support_control'),
                    showExtendedInfo: (data.USER_OPTIONS || {}).show_extended_client_info == 'true',
                    superRightsToSscPresent: superRightsToSscPresent,
                    superSubclientPresent: superSubclientPresent,
                    isAgencyViewOwnRep: isAgencyViewOwnRep,
                    readonly: hasLoginRights('superreader_control', 'media_control'),
                    needSearch: !!(clients.length > 1 || data.is_pagination_enabled),
                    isPaginationEnabled: !!data.is_pagination_enabled
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        })
    )
);

block('p-clients').content()(function() {
    var pageParams = this.pageParams,
        data = this.data,
        form = data.FORM || {},
        search = form.search,
        resetUrlParams = {};

    form.tab && (resetUrlParams.tab = form.tab);
    form.ulogin && (resetUrlParams.ulogin = form.ulogin);

    return [
        {
            block: 'l-page',
            mods: {
                layout: '16-50-30'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    center: [{
                        block: 'p-clients',
                        elem: 'header'
                    }],
                    ctxCells: {
                        center: {
                            attrs: {
                                colspan: '2'
                            }
                        }
                    }
                }
            ]
        },
        {
            block: 'l-page',
            mods: {
                layout: '84'
            },
            content: [
                {
                    elem: 'row',
                    center: [{
                        block: 'p-clients',
                        elem: 'tabs'
                    }]
                },
                {
                    elem: 'row',
                    mix: pageParams.needSearch && [{
                        block: 'b-search-on-list',
                        mods: {
                            type: pageParams.isPaginationEnabled ? 'offline' : 'online'
                        }
                    }],
                    center: [
                        pageParams.needSearch && {
                            block: 'b-search-on-list',
                            elem: 'input',
                            value: search,
                            hint: iget2('p-clients', 'nayti-klienta', 'Найти клиента')
                        },
                        pageParams.isPaginationEnabled && [
                            {
                                block: 'b-search-on-list',
                                elem: 'button'
                            },
                            !!search && {
                                block: 'b-search-on-list',
                                elem: 'reset-link',
                                url: u.getUrl(data.cmd, resetUrlParams)
                            }
                        ],
                        ((data.subclients || []).length || (pageParams.isPaginationEnabled && search)) && {
                            block: 'b-showclients-list',
                            mods: {
                                metrika: pageParams.showExtendedInfo ? '' : 'hidden',
                                type: 'clients'
                            }
                        },
                        (pageParams.showAux || this.pageParams.superRightsToSscPresent ||
                            this.pageParams.superSubclientPresent) && {
                                block: 'p-clients',
                                elem: 'aux-actions'
                            }
                    ]
                }
            ]
        }
    ];
});
