match(function() {
    return this.data.cmd === 'errorRbac';
})(

    block('app-main').mode('page-block')({
        block: 'p-common-error',
        mods: {
            page: 'rbac'
        }
    }),

    block('b-page').mode('title')(function() {
        return this.data.error.toString();
    })
);

block('p-common-error').mod('page', 'rbac')(
    content()(function() {
        var data = this.data,
            passportHost = this['i-global']['passport-host'];

        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [{
                elem: 'row',
                left: true,
                center: [
                    !!data.error.toString() && {
                        block: 'p-common-error',
                        elem: 'error',
                        content: {
                            block: 'p-common-error',
                            mods: {
                                page: 'rbac'
                            },
                            elem: 'complicated-error',
                            errorCode: data.error_code,
                            content: data.error.__raw
                        }
                    },
                //"Нет прав для выполнения данной операции!" || "Ошибка проверки прав доступа"
                    u._.contains([1, 2], data.error_code) && {
                        block: 'p-common-error',
                        elem: 'message',
                        content: iget2('p-common-error', 'signin-zaydite-pod-loginom', '{signin}, который обычно используете для работы с Директом.', {
                            signin: function(text) {
                                return {
                                    block: 'link',
                                    mix: [{
                                        block: 'p-common-error',
                                        elem: 'passport-link'
                                    }],
                                    url: u.formatUrl({
                                        host: passportHost,
                                        path: 'passport',
                                        query: {
                                            mode: 'logout',
                                            retpath: encodeURIComponent(
                                                (data.request_method == 'POST' && data.current_url &&
                                                    data.current_url.length > 2048) ?
                                                        data.SCRIPT_CLEAR :
                                                        data.current_url
                                            )
                                        }
                                    }),
                                    content: text
                                };
                            }(iget2('p-common-error', 'signin-zaydite-pod-loginom-param-signin', 'Зайдите под логином')),

                            context: 'signin - Зайдите под логином'
                        })
                    }
                ],
                right: true
            }]
        };
    }),

    elem('complicated-error')(
        match(function() {
            return true;
        }).def()(function() {
            return this.ctx.content;
        }),

        match(function() {
            return this.ctx.errorCode === 3;
        }).def()(function() {
            return [
                this.data.error.toString(),
                '<br><br>',
                iget2(
                    'p-common-error',
                    'poprobuyte-pozhaluysta-vypolnit-sleduyushchie',
                    'Попробуйте, пожалуйста, выполнить следующие действия'
                ) + ':',
                {
                    elem: 'list',
                    content: [
                        {
                            elem: 'list-item',
                            content: [
                                {
                                    block: 'link',
                                    url: u.getCommonHelpUrl('/common/browsers-settings/browsers-cookies.xml'),
                                    content: iget2('p-common-error', 'udalite-fayly-cookie', 'удалите файлы cookie')
                                },
                                ';'
                            ]
                        },
                        {
                            elem: 'list-item',
                            content: [
                                {
                                    block: 'link',
                                    url: u.getCommonHelpUrl('/common/browsers-settings/browsers-cache.xml'),
                                    content: iget2('p-common-error', 'ochistite-kesh-brauzera', 'очистите кэш браузера')
                                },
                                ';'
                            ]
                        },
                        {
                            elem: 'list-item',
                            content: iget2(
                                'p-common-error',
                                'otklyuchite-v-brauzere-rezhim',
                                'отключите в браузере режим инкогнито или дополнения, блокирующие cookie'
                            ) + ';'
                        },
                        {
                            elem: 'list-item',
                            content: iget2('p-common-error', 'vospolzuytes-servisom-v-drugom', 'воспользуйтесь сервисом в другом браузере') + '.'
                        }
                    ]
                },
                iget2(
                    'p-common-error',
                    'esli-ukazannye-rekomendacii-ne',
                    'Если указанные рекомендации не помогли, обратитесь в службу поддержки через {link}.',
                    {
                        link: function(text) {
                            return {
                                block: 'link',
                                url: iget2('p-common-error', 'http-yandex-support-access-xls', 'https://yandex.ru/support/direct/troubleshooting/access.html#xls'),
                                content: text
                            };
                        }(iget2('p-common-error', 'esli-ukazannye-rekomendacii-ne-param-link', 'форму обратной связи')),

                        context: 'link - форму обратной связи'
                    }
                )
            ];
        })
    )
);
