match(function() {
    return this.data.cmd === 'retryLater';
})(

    block('app-main').mode('page-block')({
        block: 'p-common-error',
        mods: {
            page: 'retry-later'
        }
    }),

    block('b-page').mode('title')(function() {
        return iget2('p-common-error', 'kampaniya-zablokirovana', 'Кампания заблокирована');
    })
);

block('p-common-error').mod('page', 'retry-later')(
    addJs()(function() {
        return {
            cancelUrl: encodeURIComponent(this.data.FORM.retpath)
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [{
                elem: 'row',
                left: true,
                center: [
                    {
                        block: 'p-common-error',
                        elem: 'title',
                        content: iget2('p-common-error', 'kampaniya-zablokirovana', 'Кампания заблокирована')
                    },
                    {
                        block: 'p-common-error',
                        elem: 'message',
                        content: iget2(
                            'p-common-error',
                            'v-dannyy-moment-nevozmozhno',
                            'В данный момент невозможно изменить кампанию, попробуйте выполнить операцию позднее или продолжить выполнение со снятием блокировки'
                        )
                    },
                    !this.data.NoRetry && {
                        block: 'p-common-error',
                        elem: 'retry',
                        excludeParams: ['capid', 'capcode', 'release_camp_lock'],

                        action: this.data.script,
                        method: this.data.request_method,

                        cancel: !!this.data.FORM.retpath && iget2('p-common-error', 'nazad', 'Назад'),
                        submit: iget2('p-common-error', 'razblokirovat', 'Разблокировать'),
                        submitAttrs: {
                            name: 'release_camp_lock',
                            value: '1'
                        }
                    }
                ],
                right: true
            }]
        };
    })
);
