match(function() {
    return this.data.cmd === 'showQuestion';
})(

    block('app-main').mode('page-block')({
        block: 'p-common-error',
        mods: {
            page: 'show-question'
        }
    }),

    block('b-page').mode('title')(function() {
        return iget2('p-common-error', 'proizoshlo-nestandartnoe-obrashchenie-k', 'Произошло нестандартное обращение к интерфейсу!');
    })
);

block('p-common-error').mod('page', 'show-question')(

    addJs()(function() {
        return {
            cancelUrl: encodeURIComponent(this.data.script)
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [{
                elem: 'row',
                left: true,
                center: [
                    {
                        block: 'p-common-error',
                        elem: 'warning',
                        content: iget2('p-common-error', 'proizoshlo-nestandartnoe-obrashchenie-k', 'Произошло нестандартное обращение к интерфейсу!')
                    },
                    this.data.cmd_description && {
                        block: 'p-common-error',
                        elem: 'message',
                        content: iget2('p-common-error', 'sdelana-popytka-vypolneniya-sleduyushchego', 'Сделана попытка выполнения следующего действия:')
                    },
                    {
                        block: 'p-common-error',
                        elem: 'retry',
                        excludeParams: ['captcha_id', 'captcha_code'],
                        action: this.data.SCRIPT_CLEAR,
                        method: this.data.request_method,
                        submit: iget2('p-common-error', 'prodolzhit-132', 'Продолжить'),
                        cancel: iget2('p-common-error', 'otmenit', 'Отменить')
                    }
                ]
            }]
        };
    })
);
