match(function() {
    return this.data.cmd === 'error';
})(
    block('app-main')(
        mode('page-block')('p-common-error'),
        mode('is-footer-enabled')(function() {
            return !this.data.FORM.popupMode;
        }),
        mode('is-header-enabled')(function() {
            return !this.data.FORM.popupMode;
        }),
        mode('hide-chat-on-page')(function() {
            return !this.data.FORM.popupMode;
        })
    ),

    block('b-page')(

        mode('title')(''),

        mode('head')(function() {
            return (applyNext() || []).concat(this.data.refresh ?
                [{
                    elem: 'meta',
                    attrs: {
                        'http-equiv': 'Refresh',
                        content: this.data.refresh.time + '; url=' + this.data.refresh.url
                    }
                }] :
                []);
        })
    )

);

block('p-common-error')(
    js()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    center: {
                        block: 'b-page-title',
                        title: (this.data.page_title || (this.data.hash && this.data.hash.title) || '').toString()
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    center: [
                        {
                            block: 'p-common-error',
                            elem: 'message',
                            content: (this.data.msg || this.data.error || '').toString().split('\n').join('<br>') || iget2(
                                'p-common-error',
                                'k-sozhaleniyu-servis-vremenno',
                                'К сожалению, сервис временно недоступен. Попробуйте перегрузить страницу или обратитесь к сервису позже. Мы делаем все возможное для скорейшего решения проблемы. Извините за доставленное неудобство.'
                            )
                        },
                        this.data.hash && this.data.hash.return_to && {
                            block: 'p-common-error',
                            elem: 'return',
                            content: {
                                block: 'link',
                                url: this.data.hash.return_to.href.toString(),
                                content: (this.data.hash.return_to.text || iget2('p-common-error', 'vernutsya-nazad', 'вернуться назад')).toString()
                            }
                        }
                    ]
                }
            ]
        };
    }),

    elem('warning').content()(function() {
        return [
            {
                block: 'icon',
                mods: {
                    'size-16': 'alert'
                },
                alt: '!'
            },
            ' ',
            {
                elem: 'warning-urgent',
                content: iget2('p-common-error', 'vnimanie', 'Внимание!')
            },
            ' ',
            {
                elem: 'warning-essence',
                content: applyNext()
            }
        ];
    }),

    elem('message').content()(function() {
        return [
            applyNext(),
            this.data.cmd_description && [
                '&nbsp;&nbsp;',
                {
                    elem: 'cmd',
                    content: '' + this.data.cmd_description
                }
            ]
        ];
    }),

    elem('retry').content()(function() {
        return [
            (function() {
                var params = u.getUrlParams(this.ctx.excludeParams || []);

                return Object.keys(params).map(function(key) {
                    if (params[key] != undefined) {
                        return {
                            elem: 'hidden-input',
                            name: key,
                            // ignore stringify
                            value: /^json_/.test(key) ? JSON.stringify(params[key]) : u.escapeHTML(params[key])
                        };
                    }
                });
            }.call(this)),
            this.ctx.cancel && {
                block: 'button',
                mix: [{
                    block: 'p-common-error',
                    elem: 'cancel'
                }],
                type: 'submit',
                content: this.ctx.cancel
            },
            this.ctx.submit && {
                block: 'button',
                type: 'submit',
                mods: {
                    theme: 'action'
                },
                name: this.ctx.submitAttrs && this.ctx.submitAttrs.name || '',
                value: this.ctx.submitAttrs && this.ctx.submitAttrs.value || '',
                content: this.ctx.submit
            }
        ];
    })
);
