match(function() {
    return this.data.cmd === 'showCompetitors';
})(

    block('app-main').mode('page-block')('p-competitors'),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-competitors', 'obyavleniya-konkurentov-po-zaprosu', 'Объявления конкурентов по запросу') + ' ' + this.data.request.toString();
        }),

        mode('content-only')(true))
);

block('p-competitors')(
    addJs()(true),

    content()(function() {
        var data = this.data,
            banners = data.banners;

        return [
            {
                elem: 'request-status',
                elemMods: {
                    'has-banners': banners.length ? 'yes' : 'no'
                },
                request: data.request.toString()
            },
            {
                elem: 'competitors-list',
                content: {
                    block: 'b-competitors-banners-list',
                    banners: banners,
                    userRights: data.login_rights
                }
            },
            {
                elem: 'close-button'
            }
        ];
    }),

    elem('request-status').content()(
        elemMod('has-banners', 'yes')(function() {
            return [
                iget2('p-competitors', 'obyavleniya-po-zaprosu-laquo', 'Объявления по запросу &laquo;{foo}&raquo;', {
                    foo: this.ctx.request
                }),
                {
                    elem: 'compete-regions-note',
                    content: iget2(
                        'p-competitors',
                        'vnimanie-obyavleniya-konkuriruyut-tolko',
                        'Внимание! Объявления конкурируют только в перекрывающихся регионах.'
                    )
                }
            ];
        }),
        elemMod('has-banners', 'no')(function() {
            return iget2('p-competitors', 'obyavleniy-po-zaprosu-laquo', 'Объявлений по запросу &laquo;{foo}&raquo; не найдено', {
                foo: this.ctx.request
            });
        })
    ),

    elem('market-note').content()(function() {
        return iget2(
            'p-competitors',
            'po-vashemu-zaprosu-na-poiske',
            'По вашему запросу на поиске Яндекса показываются товарные предложения Маркета, их кликабельность и ставка учитываются при показе вашего объявления. Если в ваших объявлениях эти показатели окажутся ниже, ваше объявление, включенное для показов на поиске, покажется только на тех страницах результатов поиска, где нет предложений Маркета.'
        );
    }),

    elem('close-button').content()(function() {
        return {
            block: 'button',
            content: iget2('p-competitors', 'zakryt-okno', 'Закрыть окно')
        };
    })
);
