match(function() {
    return this.data.cmd === 'createLogin';
})(

    block('app-main').mode('page-block')('p-create-login'),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-create-login', 'sozdanie-novogo-logina', 'Создание нового логина');
        }),

        mode('content-only')(true))
);

block('p-create-login')(

    addJs()(function() {
        return {
            createdLogin: this.data.created_login,
            from: this.data.FORM.from
        };
    }),

    content().match(function() {
        return !this.data.created_login;
    })(function() {
        return {
            block: 'b-layout-form',
            mods: {
                'auto-append-colons': 'yes'
            },
            mix: [{
                block: 'p-create-login',
                elem: 'form'
            }],
            mixes: {
                label: {
                    block: 'p-create-login',
                    elem: 'label'
                },
                control: {
                    block: 'p-create-login',
                    elem: 'control'
                },
                header: {
                    block: 'p-create-login',
                    elem: 'header'
                },
                row: {
                    block: 'p-create-login',
                    elem: 'row'
                },
                submit: {
                    block: 'p-create-login',
                    elem: 'submit'
                }
            },
            method: 'GET',
            action: this.data.SCRIPT,
            header: [
                {
                    block: 'b-page-title',
                    mix: [{
                        block: 'p-create-login',
                        elem: 'title'
                    }],
                    content: iget2('p-create-login', 'sozdanie-novogo-logina', 'Создание нового логина')
                },
                (this.data.error || this.data.passport_error || this.data.others_logins) && applyCtx({
                    block: 'p-create-login',
                    elem: 'errors',
                    errorMessage: this.data.others_logins &&
                        ('"' + this.data.FORM.newlogin + '" – ' + iget2('p-create-login', 'login-uzhe-zanyat', 'логин уже занят')),
                    errorCode: this.data.error,
                    passportError: this.data.passport_error
                }),
                this.data.others_logins && applyCtx({
                    block: 'p-create-login',
                    elem: 'recommends',
                    logins: this.data.others_logins
                })
            ],
            rows: [
                {
                    name: 'newlogin',
                    title: iget2('p-create-login', 'login', 'Логин'),
                    comment: iget2(
                        'p-create-login',
                        'login-dolzhen-sostoyat-iz',
                        'логин должен состоять из символов A-z, 0-9, -, начинаться с буквы, заканчиваться буквой или цифрой и содержать не более 20 символов'
                    )
                },
                {
                    name: 'name',
                    title: iget2('p-create-login', 'imya', 'Имя')
                },
                {
                    name: 'family',
                    title: iget2('p-create-login', 'familiya', 'Фамилия')
                },
                {
                    name: 'password1',
                    title: iget2('p-create-login', 'parol', 'Пароль'),
                    type: 'password',
                    comment: iget2(
                        'p-create-login',
                        'parol-dolzhen-soderzhat-ne',
                        'Пароль должен содержать не менее 6 символов из списка: A-z, 0-9, ! @ # % ^ & * ( ) _ - + и не может совпадать с логином.'
                    )
                },
                {
                    name: 'password2',
                    type: 'password',
                    title: iget2('p-create-login', 'podtverdite-parol', 'Подтвердите пароль')
                }
            ].map(function(field) {
                var name = field.name;

                return {
                    label: field.title,
                    control: [
                        {
                            block: 'input',
                            mods: {
                                type: field.type || ''
                            },
                            mix: [{
                                block: 'p-create-login',
                                elem: name + '-input'
                            }],
                            name: name,
                            value: this.data.FORM[name],
                            content: {
                                elem: 'control'
                            }
                        },
                        field.comment && {
                            block: 'p-create-login',
                            elem: 'comment',
                            content: field.comment
                        }
                    ]
                };
            }, this),
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'createLogin'
                },
                {
                    name: 'from',
                    value: this.data.FORM.from
                },
                {
                    name: 'process',
                    value: 1
                },
                {
                    name: 'bem',
                    value: 1
                }
            ],
            submit: {
                block: 'button',
                type: 'submit',
                content: iget2('p-create-login', 'zaregistrirovat', 'Зарегистрировать')
            }
        };
    }),

    elem('errors').content()(function() {
        if (this.ctx.errorMessage) return this.ctx.errorMessage;

        switch (this.ctx.errorCode) {
            case '2':
                return iget2('p-create-login', 'sozdanie-logina-nevozmozhno', 'Создание логина невозможно') + ' ' + this.data.error_msg;
            case '10':
                return iget2('p-create-login', 'ne-vse-polya-zapolneny-133', 'Не все поля заполнены');
            case '11':
                return iget2('p-create-login', 'vvyodennye-paroli-ne-sovpadayut', 'Ввёденные пароли не совпадают');
        }

        switch (this.ctx.passportError) {
            case 'login.long':
                return iget2('p-create-login', 'login-slishkom-dlinnyy', 'логин слишком длинный');
            case 'login.notavailable':
                return iget2('p-create-login', 'login-dlya-registracii-nedostupen', 'логин для регистрации недоступен');
            case 'login.prohibitedsymbols':
                return iget2('p-create-login', 'login-soderzhit-zapreshchennye-simvoly', 'логин содержит запрещенные символы');
            case 'login.startswithdigit':
                return iget2('p-create-login', 'login-ne-dolzhen-nachinatsya', 'логин не должен начинаться с цифры');
            case 'login.startswithdot':
                return iget2('p-create-login', 'login-ne-dolzhen-nachinatsya-134', 'логин не должен начинаться с точки');
            case 'login.startswithhypen':
                return iget2('p-create-login', 'login-ne-dolzhen-nachinatsya-135', 'логин не должен начинаться с дефиса');
            case 'login.endwithdot':
                return iget2('p-create-login', 'login-ne-dolzhen-zakanchivatsya', 'логин не должен заканчиваться точкой');
            case 'login.endswithhypen':
                return iget2('p-create-login', 'login-ne-dolzhen-zakanchivatsya-136', 'логин не должен заканчиваться дефисом');
            case 'login.doubleddot':
                return iget2('p-create-login', 'login-ne-dolzhen-soderzhat', 'логин не должен содержать две точки подряд');
            case 'login.doubledhypen':
                return iget2('p-create-login', 'login-ne-dolzhen-soderzhat-137', 'логин не должен содержать два дефиса подряд');
            case 'login.dothypen':
                return iget2('p-create-login', 'login-ne-dolzhen-soderzhat-138', 'логин не должен содержать точку и дефис подряд');
            case 'login.hypendot':
                return iget2('p-create-login', 'login-ne-dolzhen-soderzhat-139', 'логин не должен содержать дефис и точку подряд');
            case 'account.already_registered':
                return iget2('p-create-login', 'k-sozhaleniyu-login-zanyat', 'к сожалению; логин занят');
            case 'password.prohibitedsymbols':
                return iget2('p-create-login', 'parol-soderzhit-zapreshchennye-simvoly', 'пароль содержит запрещенные символы');
            case 'password.weak':
                return iget2('p-create-login', 'parol-slishkom-prostoy', 'пароль слишком простой');
            case 'password.short':
                return iget2('p-create-login', 'parol-slishkom-korotkiy', 'пароль слишком короткий');
            case 'password.long':
                return iget2('p-create-login', 'parol-slishkom-dlinnyy', 'пароль слишком длинный');
            case 'password.likelogin':
                return iget2('p-create-login', 'parol-ne-mozhet-sovpadat', 'пароль не может совпадать с логином');
        }

    }),

    elem('recommends').match(function() {
        return this.ctx.logins;
    }).content()(function() {
        return [
            iget2('p-create-login', 'vy-mozhete-vybrat-odin', 'Вы можете выбрать один из следующих логинов') + ':',
            {
                elem: 'logins',
                content: this.ctx.logins.map(function(login) {

                    return {
                        block: 'link',
                        mods: {
                            pseudo: 'yes'
                        },
                        mix: [{
                            block: 'p-create-login',
                            elem: 'fill-login',
                            js: {
                                login: login
                            }
                        }],
                        content: login
                    };
                })
            }
        ];
    })
);
