match(function() {
    return this.data.cmd === 'creativePreview';
})(

    block('app-main')(
        mode('page-block')('p-creative-preview'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false)
    ),

    block('b-page')(
        elem('static-js').replace()(function() {
            var data = this.data,
                creativeProps,
                queryParams,
                creativeId,
                batchId,
                previewType;

            queryParams = u.parseUrl(data.current_url).query;
            creativeId = queryParams.creativeId;
            batchId = queryParams.batchId;
            previewType = {
                image: 'adaptive0418',
                video: 'video-addition-preview',
                html5: 'html5-preview',
            }[queryParams.creativeType];

            creativeProps = {
                creativeId: creativeId ? decodeURIComponent(creativeId).match(/\d+/)[0] : '',
                batchId: batchId ? decodeURIComponent(batchId).match(/[a-z0-9]+/i)[0] : '',
                previewType: previewType,
                cspNonce: data.csp_nonce,
                isHtml5CompactPreview: queryParams.creativeType === 'html5' && queryParams.isCompactPreview === 'true',
                isCpm: queryParams.cpm === '1'
            };

            if (queryParams.creativeType === 'video') {
                creativeProps.width = '100%';
                creativeProps.height = '100%';
            }

            return [
                this.addUtilityScripts(),
                {
                    elem: 'js',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.expandStaticFileNameForDna('static/js/creativePreview.' + this.lang + '.js')
                },
                {
                    elem: 'js',
                    content: '(function(){var root=document.getElementById("app-wrapper");' +
                    'if(root){' +
                    'var elem=creativePreview.reactCreateElement(creativePreview.components.CreativePreview,' + JSON.stringify(Object.assign({}, creativeProps)) + ');' + //ignore stringify
                    'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3070\');' +
                    'creativePreview.reactDOMRender(elem,root);' +
                    'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3036\');' +
                    '}})()'
                }
            ];
        }),

        mode('head')(function() {
            return [
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-timing'
                    })
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-error-counter'
                    })
                },
                {
                    elem: 'css',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.expandStaticFileNameForDna('static/css/main.' + this.lang + '.css')
                },
                {
                    elem: 'css',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.expandStaticFileNameForDna('static/css/creativePreview.' + this.lang + '.css')
                },
                this.addFavicons()
            ];
        }),

        elem('body').replace()(function() {
            return [
                { elem: 'content' },
                { elem: 'static-js' }
            ];
        })
    )
);

block('p-creative-preview')(
    content()(function() {
        return [
            {
                elem: 'app-wrapper',
                attrs: {
                    id: 'app-wrapper',
                    style: 'height: 100vh',
                },
                content: ''
            }
        ];
    })
);
