block('p-disabling-domain').elem('data-table')(

    content()(function() {
        return {
            elem: 'no-domain-notice',
            content: iget2('p-disabling-domain', 'otklyuchennyh-domenov-net', 'Отключенных доменов нет')
        };
    }),

    match(function() {
        return this.ctx.domains.length;
    }).def()(function() {
        return applyCtx({
            block: 'b-data-table',
            mods: {
                'has-num-column': 'yes'
            },
            mix: [
                {
                    block: 'b-style-table',
                    mods: {
                        theme: 'gray-list'
                    }
                },
                {
                    block: 'p-disabling-domain',
                    elem: 'data-table'
                }
            ],
            mixes: {
                headerCell: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }],
                cell: function(key) {
                    var mix = [{
                        block: 'b-style-table',
                        elem: 'cell'
                    }];

                    if (key === 'domain') {
                        mix.push({
                            block: 'p-disabling-domain',
                            elem: 'table-cell-expand'
                        });
                    }

                    if (key === 'actions') {
                        mix.push({
                            block: 'p-disabling-domain',
                            elem: 'table-cell-actions'
                        });
                    }

                    return mix;
                }
            },
            numColTitle: '&#8470;',
            rows: this.ctx.domains.map(function(domain) {
                return {
                    domain: domain
                };
            }),
            columns: [
                {
                    key: 'domain',
                    title: iget2('p-disabling-domain', 'domen', 'Домен')
                },
                {
                    key: 'actions',
                    ctx: this.ctx,
                    transformData: function(row) {
                        return {
                            block: 'p-disabling-domain',
                            elem: 'action-link',
                            elemMods: this.ctx.readOnly && {
                                disabled: 'yes'
                            },
                            js: !this.ctx.readOnly && {
                                domain: row.domain
                            },
                            content: iget2('p-disabling-domain', 'vklyuchit', 'Включить')
                        };
                    }
                }
            ]
        });
    })
);
