match(function() {
    return this.data.cmd === 'showBlockedDomainsTitles';
})(

    block('app-main')(

        mode('preprocess')(function() {
            !/(super|support)/.test(this.data.login_rights.role) && (this.data.readOnly = true);

            return this.data;
        }),

        mode('page-block')('p-disabling-domain')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-disabling-domain', 'otklyuchit-pokaz-domena-v', 'Отключить показ домена в заголовке');
    })
);

block('p-disabling-domain')(

    js()(function() {
        return !this.data.readOnly && {
            domains: this.data.blocked_domain
        };
    }),

    content()(function() {
        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-43-37'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        right: true,
                        rgap: true,
                        center: [
                            {
                                block: 'b-page-title',
                                content: {
                                    elem: 'title',
                                    content: iget2('p-disabling-domain', 'otklyuchit-pokaz-domena-v', 'Отключить показ домена в заголовке')
                                }
                            },
                            {
                                block: 'p-disabling-domain',
                                elem: 'form',
                                readOnly: this.data.readOnly,
                                domains: this.data.blocked_domain
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('form').wrap()(function() {
        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'i-form',
                    mods: {
                        submit: 'bem-event'
                    },
                    js: true
                },
                {
                    block: 'p-disabling-domain',
                    elem: 'form'
                }
            ],
            rows: [
                {
                    block: 'p-disabling-domain',
                    elem: 'title',
                    content: iget2('p-disabling-domain', 'ukazhite-spisok-domenov-cherez', 'Укажите список доменов через пробел или запятую')
                },
                {
                    block: 'input',
                    mods: {
                        type: 'textarea',
                        disabled: this.ctx.readOnly && 'yes'
                    },
                    mix: [{
                        block: 'p-disabling-domain',
                        elem: 'domains'
                    }],
                    name: 'domains',
                    content: [{
                        elem: 'control',
                        attrs: {
                            rows: 5
                        }
                    }]
                },
                {
                    block: 'p-disabling-domain',
                    elem: 'buttons',
                    content: [
                        {
                            block: 'button',
                            type: this.ctx.readOnly ? 'button' : 'submit',
                            mix: [{
                                block: 'p-disabling-domain',
                                elem: 'disable-button'
                            }],
                            mods: {
                                disabled: 'yes'
                            },
                            content: iget2('p-disabling-domain', 'otklyuchit', 'Отключить')
                        },
                        {
                            block: 'spin',
                            mix: [{
                                block: 'p-disabling-domain',
                                elem: 'spin'
                            }],
                            js: true,
                            mods: {
                                theme: 'gray-16'
                            }
                        }
                    ]
                },
                {
                    block: 'p-disabling-domain',
                    elem: 'title',
                    elemMods: {
                        large: 'yes'
                    },
                    content: iget2('p-disabling-domain', 'tekushchiy-spisok-otklyuchennyh-domenov', 'Текущий список отключенных доменов')
                },
                {
                    block: 'p-disabling-domain',
                    elem: 'disabled-domains-list',
                    content: {
                        elem: 'data-table',
                        readOnly: this.ctx.readOnly,
                        domains: this.ctx.domains
                    }
                }
            ]
        };
    })
);
