(function() {
    var ERROR_MESSAGES = {
            EMPTY_REQUEST: iget2('p-disabling-domain', 'ne-ukazan-spisok-domenov', 'Не указан список доменов'),

            ALREADY_BLOCKED: iget2('p-disabling-domain', 'domen-uzhe-zablokirovan-domeny', '{Домен уже заблокирован|Домены уже заблокированы}'),
            INVALID_DOMAIN: iget2('p-disabling-domain', 'ukazan-ne-vernyy-domen', '{Указан не верный домен|Указаны не верные домены}'),
            BANNERS_NOT_FOUND: iget2('p-disabling-domain', 'domen-ne-nayden-domeny', '{Домен не найден|Домены не найдены}'),

            NOT_BLOCKED: iget2('p-disabling-domain', 'ne-udalos-otklyuchit-domen', 'Не удалось отключить {домен|домены}'),
            SERVER_ERROR: iget2('p-disabling-domain', 'ne-udalos-vypolnit-operaciyu', 'Не удалось выполнить операцию, попробуйте позже')
        },
        ERRORS_ORDER = [
            'EMPTY_REQUEST', 'ALREADY_BLOCKED', 'INVALID_DOMAIN', 'BANNERS_NOT_FOUND', 'NOT_BLOCKED', 'SERVER_ERROR'
        ];

    BEM.DOM.decl('p-disabling-domain', {

        onSetMod: {
            js: function() {
                this._submitButton = this.findBlockOn('disable-button', 'button');
                this._inputArea = this.findBlockOn('domains', 'input');

                this._inputArea.on('change', this._checkSubmitButton, this)
            }
        },

        /**
         * Разблокирует домены
         * @param {String} domain название домена
         * @param {BEM} spin блок спиннера для анимации запросов
         * @returns {Promise}
         */
        turnOn: function(domain, spin) {
            var promise = $.Deferred();

            BEM.blocks['b-confirm'].open({
                message: iget2(
                    'p-disabling-domain',
                    'vy-uvereny-chto-hotite-140',
                    'Вы уверены, что хотите включить показ домена в заголовке для домена {foo}',
                    {
                        foo: domain
                    }
                ),
                onYes: function() {
                    this
                        ._call({ cmd: 'ajaxUnlockDomain', domain: domain }, spin)
                        .then(function(result) { promise.resolve(result); })
                        .fail(function() { promise.reject(); });
                },
                onNo: function() { promise.reject(); }
            }, this);

            return promise;
        },

        /**
         * Блокирует домены
         * @param {String} domains список доменов в виде строки
         * @param {BEM} spin блок спиннера для анимации запросов
         * @returns {Promise}
         */
        turnOff: function(domains, spin) {
            return this._call({ cmd: 'ajaxBlockDomains', domains: domains }, spin);
        },

        /**
         * Блокирует/разблокирует кнопку отправки формы
         * @private
         */
        _checkSubmitButton: function() {
            this._submitButton.toggleMod('disabled', 'yes', !this._inputArea.val());
        },

        /**
         * Обрабатывает ответ от сервера при блокировке/разблокировке
         * Если есть ошибки, то они будут выведены как алерт
         * @param {Object} result объект с результатом запроса и общими ошибками
         * @param {Boolean} [isDisabling] обработать как результат блокировки
         * @private
         */
        _processResponse: function(result, isDisabling) {
            var errors;

            if (result.error) {
                errors = {};

                errors[result.error] = [];
            }

            if (!errors) {
                var data = this._processResult(result.result || [], isDisabling);

                errors = data.errors;

                if (data.domains.length) {
                    this._repaint();
                }
            }

            errors && BEM.blocks['b-confirm'].alert(this._composeErrorMessage(errors));
        },

        /**
         * Обрабатывает результат ответа
         * @param {Object[]} result список объектов с описанием домена и статуса блокировки (+ ошибки, если есть)
         * @param {Boolean} [isDisabling] обработать как результат блокировки
         * @returns {{domains: String, errors: Object}}
         * @private
         */
        _processResult: function(result, isDisabling) {
            var errors,
                domains = result
                    .filter(function(item) {
                        if (item.error) {
                            errors || (errors = {});
                            errors[item.error] || (errors[item.error] = []);

                            errors[item.error].push(item.domain);
                        }

                        return isDisabling ? !!item.disabled : !item.disabled;
                    })
                    .map(function(item) {
                        return item.domain;
                    }, this);

            if (domains.length) {
                this.params.domains = isDisabling ?
                    domains.concat(this.params.domains) :
                    this.params.domains.filter(function(domain) {
                        return domains.indexOf(domain) === -1;
                    });
            }

            return { domains: domains, errors: errors };
        },

        /**
         * Перерисовывает таблицу с заблокированными доменами
         * @private
         */
        _repaint: function() {
            BEM.DOM.replace(this.findElem('data-table'), BEMHTML.apply({
                block: 'p-disabling-domain',
                elem: 'data-table',
                domains: this.params.domains
            }));
        },

        /**
         * Составляет сообщение об ошибке
         * @param {Object} errors хэш с ключами кодов ошибок и значениями списком доменов, по которым были ошибки
         * @returns {String}
         * @private
         */
        _composeErrorMessage: function(errors) {
            return ERRORS_ORDER
                .filter(function(key) {
                    return errors[key];
                })
                .map(function(key) {
                    var domains = errors[key],
                        count = domains.length;

                    return {
                        elem: 'error-message',
                        content: u.pluralForms(ERROR_MESSAGES[key], count, count) + (count ?
                            ': ' + u.escapeHTML(domains.join(', ')) :
                            '')
                    };
                });
        },

        /**
         * Делает запрос
         * @param {Object} params параметры запроса
         * @param {String} params.cmd серверный контроллер
         * @param {BEM} spin блок спиннера для анимации запросов
         * @returns {Promise}
         * @private
         */
        _call: function(params, spin) {
            var responsePromise = $.Deferred(),
                blockingPromise = $.Deferred(),
                controls = this.findBlocksInside('action-link', 'link').concat(this._submitButton, this._inputArea);

            // блокировка всех контролов, которые можно как то нажимать
            controls.forEach(function(link) { link.setMod('disabled', 'yes'); });

            spin && spin.setMod('progress', 'yes');

            BEM
                .create('i-request_type_ajax', {
                    url: u.getUrl(),
                    cache: false,
                    dataType: 'json',
                    type: 'POST',
                    callbackCtx: this,
                    onError: function() {
                        blockingPromise.resolve();

                        responsePromise.reject();
                    }
                })
                .get(params, function(response) {
                    blockingPromise.resolve();

                    responsePromise.resolve(response);
                });

            // при любом раскладе все контролы должны быть разблокированы
            blockingPromise.then(function() {
                controls.forEach(function(link) { link.delMod('disabled'); });

                spin && spin.delMod('progress');

                this._checkSubmitButton();
            }.bind(this));

            return responsePromise
                .then(function(result) {
                    this._processResponse(result, params.cmd === 'ajaxBlockDomains');
                }.bind(this))
                .fail(function() {
                    BEM.blocks['b-confirm'].alert(iget2('p-disabling-domain', 'oshibka-soedineniya-s-serverom', 'Ошибка соединения с сервером'));
                });
        }

    }, {

        live: function() {
            this
                .liveInitOnBlockInsideEvent('init', 'input')
                .liveInitOnBlockInsideEvent('submit', 'i-form', function(e) {
                    var form = e.block;

                    this
                        .turnOff(form.serialize().domains, this.findBlockOn('spin', 'spin'))
                        .done(function() { form.domElem.get(0).reset(); });
                });
        }

    });
})();
