BEM.DOM.decl('p-dynamic-media-banners', {

    onSetMod: {
        js: function() {

            u.graspSelf.call(this, {
                _creativeWrapper: 'b-creative-wrapper on creative-wrapper',
                _addBtn: 'button on add-media-banners'
            });

            this._creativesPopup = BEM.blocks['b-dynamic-media-creatives-popup'];

            this._initEvents();
        }
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this._getSubscriptionManager().dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Выполняет подписку на события
     * @private
     */
    _initEvents: function() {
        var subscriptionManager = this._getSubscriptionManager();

        subscriptionManager.wrap(this._creativeWrapper)
            .on('editCreatives', function(e, data) {
                this._editCreatives(data.creatives_data, data.groupId);

                BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
                    params: {
                        showCreatives: {
                            clickEditButton: true
                        }
                    }
                });
            }, this);

        subscriptionManager
            .on(this._addBtn, 'click', this._showAddMediaCreativePopup, this)
            .on(this._creativesPopup, 'ad-designer-close', this._onNewMediaCreativeAdded, this);
    },

    /**
     * Открывает попап добавления новых креативов
     * @returns {BEM}
     * @private
     */
    _showAddMediaCreativePopup: function() {
        this._openSmartCreativeConstructorModal(
            true,
            function() {
                this._creativesPopup.show({
                    retpathCmd: 'showCreatives'
                });
            }.bind(this)
        );

        BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
            params: {
                showCreatives: {
                    clickCreateButton: true
                }
            }
        });

        return this;
    },

    /**
     * Реакция на добавление нового креатива
     * @private
     */
    _onNewMediaCreativeAdded: function() {
        this._creativesPopup.hide();
        //перерисовываем список креативов
        this._creativeWrapper.fetchDataAndRenderBlock();
    },

    /**
     * Редактирование креативов
     * @param {Array} selectedIds
     * @param {String} [groupId]
     * @returns {BEM}
     * @private
     */
    _editCreatives: function(selectedIds, groupId) {
        var ids = selectedIds.map(function(item) {
            return item.id;
        });

        this._openSmartCreativeConstructorModal(
            false,
            function() {
                this._creativesPopup.show({
                    ids: ids,
                    groupId: groupId,
                    retpathCmd: 'showCreatives'
                });
            }.bind(this),
            ids,
            groupId
        );

        return this;
    },

    /**
     * Возвращает менеджер подписок
     * @returns {Object}
     * @private
     */
    _getSubscriptionManager: function() {
        return this._subscriptionManager || (this._subscriptionManager = BEM.create('i-subscription-manager'));
    },

    _openSmartCreativeConstructorModal: function(isNew, creativesPopupShow, ids, groupId) {
        var dna = window.dna;

        if (!dna) {
            creativesPopupShow();
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        if (this._smartCreativeConstructorModal) {
            BEM.DOM.destruct(this._smartCreativeConstructorModal);
        }

        try {
            this._smartCreativeConstructorModal = BEM.DOM.append($('body'), BEMHTML.apply({
                block: 'smart-creative-constructor' // фейковый блок
            }));

            dna.reactDOMRender(
                dna.reactCreateElement(dna.components.SmartCreativeConstructorWrapper, {
                    login: u.consts('ulogin'),
                    cspNonce: BEM.blocks['i-global'].param('nonce'),
                    isNew: isNew,
                    fetchDataAndRenderCreativeList:
                        this._creativeWrapper.fetchDataAndRenderBlock.bind(this._creativeWrapper), // перерисовываем список креативов после сохранения
                    ids: ids,
                    groupId: groupId,
                    clientFeatures: u.consts('clientFeaturesAll'),
                    operatorFeatures: u.consts('operatorFeaturesAll')
                }, null),
                this._smartCreativeConstructorModal[0]
            );
        } catch (err) {
            throw new Error('An error has occurred in DNA ' + err);
        }
    }
});
