match(function() {
    return this.data.cmd === 'editCampaignTags' || this.data.cmd === 'saveCampaignTags';
})(

    block('app-main')(
        mode('page-block')('p-edit-campaign-tags'),
        mode('is-dna-header-and-sidebar-enabled')(true)
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-edit-campaign-tags', 'upravlenie-metkami', 'Управление метками');
    })
);

block('p-edit-campaign-tags')(

    addJs()(function() {
        var data = this.data,
            params = {
                tagMaxLength: data.CONSTS.MAX_TAG_LENGTH,
                tagsMaxCount: data.CONSTS.MAX_TAGS_FOR_CAMPAIGN,
                cid: data.campaign.cid
            };

        if (data.campaign.tags) {
            params.tags = data.campaign.tags.reduce(function(tagParams, tag) {
                tagParams[tag.tag_id] = (data.FORM['tag_' + tag.tag_id] || tag.value.__raw) + '';

                return tagParams;
            }, {});
        }

        return params;
    }),

    content()(function() {

        var data = this.data,
            campaign = data.campaign;

        return {
            elem: 'form',
            action: data.SCRIPT,
            content: [
                {
                    elem: 'hidden',
                    name: 'cmd',
                    value: 'saveCampaignTags',
                },
                {
                    elem: 'hidden',
                    name: 'ulogin',
                    value: data.user_login
                },
                {
                    elem: 'hidden',
                    name: 'from_new_interface',
                    value: data.from_new_interface
                },
                {
                    elem: 'hidden',
                    name: 'cid',
                    value: campaign.cid && campaign.cid.toString()
                },
                {
                    block: 'l-page',
                    mods: {
                        layout: '16-60-16'
                    },
                    content: [
                        {
                            elem: 'row',
                            left: true,
                            center: [
                                {
                                    block: 'b-page-title',
                                    mix: [{
                                        block: 'p-edit-campaign-tags',
                                        elem: 'title'
                                    }],
                                    title: iget2('p-edit-campaign-tags', 'upravlenie-metkami', 'Управление метками')
                                },
                                campaign.cid && campaign.name && {
                                    block: 'link',
                                    mix: {
                                        block: 'p-edit-campaign-tags',
                                        elem: 'campaign-title'
                                    },
                                    url: u.getUrl('showCamp', {
                                        cid: campaign.cid,
                                        ulogin: data.user_login
                                    }),
                                    content: iget2('p-edit-campaign-tags', 'kampaniya-laquo-name-imya', 'Кампания &laquo;{name}&raquo; №{cid}', {
                                        name: campaign.name,
                                        cid: campaign.cid,
                                        context: 'name - имя; cid - номер'
                                    })
                                },
                                campaign.tags && campaign.tags.length > 0 && {
                                    block: 'dropdown',
                                    mix: {
                                        block: 'p-edit-campaign-tags',
                                        elem: 'all-tags'
                                    },
                                    content: [
                                        {
                                            block: 'button',
                                            mods: {
                                                pseudo: 'yes',
                                                theme: 'normal'
                                            },
                                            mix: [{
                                                block: 'dropdown',
                                                elem: 'switcher'
                                            }],
                                            content: iget2('p-edit-campaign-tags', 'vse-metki-spiskom', 'Все метки списком')
                                        },
                                        {
                                            elem: 'popup',
                                            elemMods: { 'has-close': 'yes' },
                                            content: {
                                                block: 'p-edit-campaign-tags',
                                                elem: 'tags-list-text',
                                                content: campaign.tags.map(function(tag) {
                                                    return tag.value.toString();
                                                }).join(', ')
                                            }
                                        }
                                    ]
                                }
                            ],
                            right: true,
                            rgap: true
                        },
                        {
                            elem: 'row',
                            left: true,
                            center: [
                                campaign.tags && campaign.tags.map(function(tag) {
                                    return applyCtx({
                                        block: 'p-edit-campaign-tags',
                                        elem: 'camp-tag',
                                        elemMods: {
                                            'tag-id': tag.tag_id.toString()
                                        },
                                        campTag: tag,
                                        errors: data.errors && data.errors[tag.tag_id]
                                    });
                                }, this),
                                {
                                    block: 'p-edit-campaign-tags',
                                    elem: 'new-tags',
                                    content: [
                                        {
                                            block: 'input',
                                            name: 'new_tags',
                                            value: data.FORM.new_tags && data.FORM.new_tags.__raw,
                                            placeholder: iget2('p-edit-campaign-tags', 'novye-metki-cherez-zapyatuyu', 'Новые метки (через запятую)'),
                                            content: [
                                                {
                                                    elem: 'control'
                                                }
                                            ]
                                        },
                                        data.errors && data.errors[0] && {
                                            elem: 'tag-errors',
                                            content: {
                                                elem: 'tag-error',
                                                content: data.errors[0].map(function(err) {
                                                    return {
                                                        elem: 'tag-errors',
                                                        content: {
                                                            elem: 'tag-error',
                                                            content: err
                                                        }
                                                    };
                                                })
                                            }
                                        }
                                    ]
                                }
                            ],
                            right: true,
                            rgap: true,
                            ctxCells: {
                                center: {
                                    mix: {
                                        block: 'p-edit-campaign-tags',
                                        elem: 'tags-list'
                                    }
                                }
                            }
                        },
                        {
                            elem: 'row',
                            left: true,
                            center: [
                                {
                                    block: 'p-edit-campaign-tags',
                                    elem: 'buttons-panel',
                                    content: [
                                        {
                                            block: 'button',
                                            type: 'submit',
                                            content: iget2('p-edit-campaign-tags', 'sohranit', 'Сохранить')
                                        }
                                    ]
                                }
                            ],
                            right: true,
                            rgap: true
                        }
                    ]
                }
            ]
        };
    }),

    elem('camp-tag').content()(function() {
        var data = this.data,
            tag = this.ctx.campTag,
            tagId = tag.tag_id,
            tagName = 'tag_' + tagId,
            countText = u.pluralize([iget2('p-edit-campaign-tags', 'groupa', 'группа'), iget2('p-edit-campaign-tags', 'groupi', 'группы'), iget2('p-edit-campaign-tags', 'group', 'групп')], tag.uses_count, '&nbsp;');

        return [
            {
                block: 'input',
                js: {
                    tagId: tagId
                },
                mix: {
                    block: 'p-edit-campaign-tags',
                    elem: 'tag-input'
                },
                name: tagName,
                value: (data.FORM[tagName] || tag.value.__raw) + '',
                content: {
                    elem: 'control'
                }
            },
            {
                block: 'p-edit-campaign-tags',
                elem: 'delete-tag',
                mix: {
                    block: 'b-icon',
                    mods: {
                        type: 'remove'
                    }
                },
                js: {
                    tagId: tagId
                },
                attrs: {
                    title: iget2('p-edit-campaign-tags', 'udalit-metku', 'Удалить метку')
                }
            },
            {
                block: 'p-edit-campaign-tags',
                elem: 'banners',
                content: tag.uses_count && +tag.uses_count ?
                    {
                        block: 'link',
                        url: data.from_new_interface ?
                            u.formatUrl({
                                path: '/dna/grid/groups',
                                query: {
                                    ulogin: data.user_login,
                                    'campaigns-ids': data.campaign.cid,
                                    tags: tagId
                                }
                            }) : u.getUrl('showCamp', {
                                cid: data.campaign.cid,
                                ulogin: data.user_login,
                                tag: tagId
                            }),
                        title: iget2('p-edit-campaign-tags', 'otbor-po-etoy-metke', 'Отбор по этой метке'),
                        content: countText
                    } :
                    countText
            },
            this.ctx.errors && {
                block: 'p-edit-campaign-tags',
                elem: 'tag-errors',
                content: this.ctx.errors.map(function(err) {
                    return {
                        elem: 'tag-error',
                        content: err
                    };
                })
            }
        ];
    })
);
