BEM.DOM.decl('p-edit-campaign-tags', {
    onSetMod: {
        js: function() {
            var newTagsInput = this.findBlockInside('new-tags', 'input');

            this._tags = this.params.tags;
            this._newTags = newTagsInput.val() || '';

            BEM.blocks['input'].on(this.elem('camp-tag'), 'change', function(e) {
                this._tags[e.block.params.tagId] = e.block.val();

                this._validateForm();
            }, this);

            newTagsInput.on('change', function(e) {
                this._newTags = e.block.val();

                this._validateForm();
            }, this);

            this
                .bindTo('delete-tag', 'click', function(e) {
                    this._deleteTag(this.elemParams(e.data.domElem).tagId);

                    this._validateForm();
                })
                .bindTo('form', 'submit', function() {
                    var isValid = this._validateForm();

                    isValid || BEM.DOM.before(this.elem('buttons-panel'), BEMHTML.apply({
                        block: 'p-edit-campaign-tags',
                        elem: 'form-error',
                        content: iget2(
                            'p-edit-campaign-tags',
                            'na-stranice-dopushcheny-oshibki',
                            'На странице допущены ошибки. Сохранение станет возможным после их исправления.'
                        )
                    }));

                    return isValid;
                });
        }
    },

    /**
     * Валидирует форму
     **/
    _validateForm: function() {
        var tags = this._tags,
            isValid = true;

        this._hideErrors();

        Object.keys(tags).forEach(function(tagId) {
            var tagErrors = this._validateTag(tags[tagId]);

            if (tagErrors && tagErrors.length) {
                isValid = false;
                this._showErrors(this.elem('camp-tag', 'tag-id', tagId), tagErrors);
            }
        }, this);

        var newTagsErrors = this._validateNewTags(this._getNormalizedValue(this._newTags));

        if (newTagsErrors && newTagsErrors.length) {
            this._showErrors(this.elem('new-tags'), newTagsErrors);
            isValid = false;
        }

        return isValid;
    },

    /**
     * Валидирует тег, возвращает массив ошибок
     * @param {String} tagValue
     * @returns {Array}
     * @private
     */
    _validateTag: function(tagValue) {
        var maxLength = this.params.tagMaxLength,
            errors = [];

        if (tagValue.length > maxLength)
            errors.push(iget2('p-edit-campaign-tags', 'prevyshena-dopustimaya-dlina', 'Превышена допустимая длина'));

        if (tagValue.indexOf(',') != -1)
            errors.push(iget2('p-edit-campaign-tags', 'zapyataya-yavlyaetsya-nedopustimym-simvolom', 'Запятая является недопустимым символом'));

        return errors;
    },

    /**
     * Валидирует новые теги
     * @param {String} newTags
     * @returns {Array}
     * @private
     */
    _validateNewTags: function(newTags) {
        if (!newTags) return [];

        var tags = newTags && newTags.split(','),
            maxLength = this.params.tagMaxLength,
            maxCount = this.params.tagsMaxCount,
            errors = [];

        if (tags.length + Object.keys(this._tags).length > maxCount)
            errors.push(iget2('p-edit-campaign-tags', 'nelzya-sozdavat-bolshe-s', 'Нельзя создавать больше {foo} меток', {
                foo: maxCount
            }));

        tags.reduce(function(errors, tag) {
            if (tag.length > maxLength)
                errors.push(iget2('p-edit-campaign-tags', 's-prevyshaet-dopustimuyu-dlinu', '{foo} превышает допустимую длину', {
                    foo: BEMHTML.apply({
                        block: 'p-edit-campaign-tags',
                        elem: 'error-camp-name',
                        tag: 'span',
                        content: '&laquo;' + u.escapeHTML(tag) + '&raquo;'
                    })
                }));

            return errors;
        }, errors);

        return errors;
    },

    /**
     * Нормализует значение тегов
     * @param {String} value
     * @returns {String}
     * @private
     */
    _getNormalizedValue: function(value) {
        return value
            .replace(/\s*,\s*/g, ',') // удаляем пробелы вокруг запятых
            .replace(/,(?=,)/g, '') // оставляем только одну запятую подряд
            .replace(/^\s*/, '') // удаляем висячие пробелы в начале
            .replace(/\s*$/, '') // удаляем висячие пробелы
            .replace(/^,/, '') // удаляем висячую запятую в начале
            .replace(/,$/, ''); // удаляем висячую запятую в конце
    },

    /**
     * Добавляет сообщение об ошибке к элементу
     * @param {jQuery} elem
     * @param {Array} errors
     * @private
     */
    _showErrors: function(elem, errors) {
        BEM.DOM.append(elem, BEMHTML.apply({
            block: 'p-edit-campaign-tags',
            elem: 'tag-errors',
            content: errors.map(function(err) {
                return {
                    elem: 'tag-error',
                    content: err
                }
            })
        }));
    },

    /**
     * Скрывает ошибки
     * @private
     */
    _hideErrors: function() {
        this.findElem('form-error').remove();
        this.findElem('tag-errors').remove();
    },

    /**
     * Удаляет тег
     * @param {String} tagId
     * @private
     */
    _deleteTag: function(tagId) {
        var elem = this.findElem('camp-tag', 'tag-id', tagId);

        if (elem.length) elem.eq(0).remove();

        delete this._tags[tagId];
    }

});
