describe('p-edit-campaign-tags', function() {

    var block;

    beforeEach(function() {
        var $block = $(BEMHTML.apply({
            block: 'p-edit-campaign-tags',
            js: {
                tagMaxLength: 10,
                tagsMaxCount: 3,
                tags: [],
                cid: 111
            },
            content: [
                { elem: 'new-tags', content: { block: 'input', content: { elem:'control' } } }
            ]
        }));

        $('body').append($block);

        BEM.DOM.init($block);

        block = $block.bem('p-edit-campaign-tags');
    });

    afterEach(function() {
        block.destruct();
    });

    describe('_validateTag', function() {

        it('должен валидировать метку', function() {
            expect(block._validateTag('ok').length).to.be.equal(0);
        });

        it('должен выдавать ошибку на слишком длинном метке', function() {
            expect(block._validateTag('longlonglonglonglonglonglonglongtag').length).to.be.equal(1);
        });

        it('должен выдавать ошибку при наличии запятой в метке', function() {
            expect(block._validateTag('tag,tag').length).to.be.equal(1);
        });

    });

    describe('_validateNewTags', function() {

        it('должен валидировать новые метки', function() {
            expect(block._validateNewTags('ok,ok,ok').length).to.be.equal(0);
        });

        it('должен выдавать ошибку на слишком длинном метке', function() {
            expect(block._validateNewTags('longlonglonglonglonglonglonglongtag,ok,ok').length).to.be.equal(1);
        });

        it('должен выдавать ошибку при слишком большом количестве меток', function() {
            expect(block._validateNewTags('tag,tag,tag,tag').length).to.be.equal(1);
        });

    });
});
