match(function() {
    return this.data.cmd === 'editVCard';
})(

    block('app-main').mode('page-block')('p-edit-vcard-headless'),

    block('b-page')(

        mode('content-only')(true),

        mode('title')(function() {
            return iget2('p-edit-vcard-headless', 'redaktirovanie-virtualnoy-vizitki', 'Редактирование виртуальной визитки');
        }),

        elem('foot-js').content()(function() {
            var langList = {
                ru: 'ru-RU',
                en: 'en-US',
                tr: 'tr-TR',
                ua: 'uk-UA'
            };

            return (applyNext() || []).concat({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });
        })
    )

);

block('p-edit-vcard-headless')(

    // для правильной работы формы редактирования визитки требуются эти переменные в this контексте
    def()(function() {
        return applyNext({
            vcard: this.data.vcard,
            bannerSuffix: '',
            banner: this.vcard && {
                geo_id: this.vcard.geo_id
            }
        });
    }),

    addJs()(function() {
        return this.data.vcard_uses_count > 1 && !this.data.FORM.bid ?
            {
                submitConfirm: iget2(
                    'p-edit-vcard-headless',
                    'informaciya-budet-izmenena-u',
                    'Информация будет изменена у всех объявлений с этой визиткой. Продолжить?'
                )
            } :
            true;
    }),

    content()(function() {
        return {
            block: 'b-layout-form',

            method: 'POST',

            action: this.data.script,

            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'saveVCard'
                },
                {
                    name: 'bids',
                    value: this.data.FORM.bid
                },
                {
                    name: 'cid',
                    value: this.data.FORM.cid
                },
                {
                    name: 'ulogin',
                    value: this.data.user_login
                },
                {
                    name: 'vcard_id',
                    value: this.vcard && this.vcard.vcard_id
                }
            ],

            rows: [
                applyCtx({
                    block: 'p-edit-vcard-headless',
                    elem: 'errors'
                }),
                applyCtx({
                    block: 'p-edit-vcard-headless',
                    elem: 'form-vcard'
                }),
                applyCtx({
                    block: 'p-edit-vcard-headless',
                    elem: 'required-notice'
                }),
                applyCtx({
                    block: 'p-edit-vcard-headless',
                    elem: 'buttons'
                })
            ]
        };
    }),

    elem('form-vcard').content()(function() {
        return {
            block: 'b-form-vcard',
            vcard: this.data.vcard
        };
    }),

    elem('required-notice').content()(function() {
        return [
            iget2('p-edit-vcard-headless', 'obratite-vnimanie-vse-polya', 'Обратите внимание - все поля, отмеченные'),
            '&nbsp;',
            {
                block: 'b-form-label',
                elem: 'mark'
            },
            iget2('p-edit-vcard-headless', 'obyazatelny-dlya-zapolneniya', ', обязательны для заполнения!')
        ];
    }),

    elem('buttons').content()(function() {
        return {
            elem: 'buttons-wrapper',
            content: [
                {
                    block: 'button',
                    type: 'submit',
                    content: this.data.FORM.bid && !this.data.vcard_uses_count ?
                        iget2('p-edit-vcard-headless', 'sozdat-vizitku', 'Создать визитку') : iget2('p-edit-vcard-headless', 'sohranit-izmeneniya', 'Сохранить изменения')
                },
                {
                    block: 'button',
                    mix: [{
                        block: 'p-edit-vcard-headless',
                        elem: 'cancel-button'
                    }],
                    type: 'button',
                    content: iget2('p-edit-vcard-headless', 'otmena', 'Отмена')
                }
            ]
        };
    })
);
