BEM.DOM.decl('p-edit-vcard-headless', {

    onSetMod: {

        js: function() {
            this._form = this.findBlockInside('b-layout-form');
            this._vcardForm = this.findBlockInside('b-form-vcard');

            this._eventBus = BEM.blocks['i-event-bus'].getEventBus(window.name);

            this._initFormEvents();
        }

    },

    /**
     * Инициализация событий формы
     * @private
     */
    _initFormEvents: function() {
        var _this = this;

        this.findBlockOn('cancel-button', 'button').on('click', function() {
            this._eventBus.trigger('edit-canceled');
        }, this);

        this._form.bindTo('submit', function(e) {
            e.preventDefault();

            if (!_this._vcardForm.setMod('validation', 'on').validate()) return;

            _this._confirmSubmit().then(function(allow) {
                allow && _this._submitForm();
            });

        });

        this._eventBus.on('edit-confirm', function(e, data) {
            // даём возможность переопределить это событие полностью
            if (e.isPropagationStopped()) return;

            var dfd = data.promise;

            BEM.blocks['b-confirm'].open({
                message: data.confirm,
                onYes: function() { dfd.resolve(true) },
                onNo: function() { dfd.resolve(false) }
            });
        });
    },

    /**
     * Подтверждение отправки формы
     * @returns {$.Deferred}
     * @private
     */
    _confirmSubmit: function() {
        var dfd = $.Deferred(),
            submitConfirm = this.params.submitConfirm;

        if (submitConfirm) {
            this._eventBus.trigger('edit-confirm', { confirm: submitConfirm, promise: dfd });
        } else {
            dfd.resolve(true);
        }

        return dfd;
    },

    _convertVcardFormat: function(serialized) {
        var toNumberArray = function(str) {
                return str ? String(str).split(',').map(Number) : undefined;
            },
            posAuto = toNumberArray(serialized.auto_point),
            boundsAuto = toNumberArray(serialized.auto_bounds),
            posManual = toNumberArray(serialized.manual_point),
            boundsManual = toNumberArray(serialized.manual_bounds);

        return {
            apart: serialized.apart,
            build: serialized.build,
            campaign_id: Number(serialized.cid),
            bids: serialized.bids ? [Number(serialized.bids)] : null,
            city: serialized.city,
            company_name: serialized.name,
            contact_person: serialized.contactperson,
            country: serialized.country,
            email: serialized.contact_email,
            extra_message: serialized.extra_message,
            house: serialized.house,
            id: Number(serialized.vcard_id),
            instant_messenger: {
                login: serialized.im_login,
                type: serialized.im_client
            },
            auto_point: posAuto && {
                x: posAuto[0],
                x1: boundsAuto[0],
                x2: boundsAuto[2],
                y: posAuto[1],
                y1: boundsAuto[1],
                y2: boundsAuto[3]
            },
            manual_point: posManual && {
                x: posManual[0],
                x1: boundsManual[0],
                x2: boundsManual[2],
                y: posManual[1],
                y1: boundsManual[1],
                y2: boundsManual[3]
            },
            metro_id: Number(serialized.metro),
            precision: String(serialized.auto_precision).toUpperCase() || 'EXACT',
            ogrn: serialized.ogrn,
            org_details_id: Number(serialized.org_details_id),
            phone: {
                city_code: serialized.city_code,
                country_code: serialized.country_code,
                extension: serialized.ext,
                phone_number: serialized.phone
            },
            street: serialized.street,
            work_time: serialized.worktime
        };
    },

    _onRequestDone: function(result) {
        var errors, errorMapper;

        if (result.success) {
            this.delMod('has-errors');
            this._eventBus.trigger('edit-completed', result.result);
        } else {
            this.setMod('has-errors', 'yes');

            errorMapper = u['p-edit-vcard-headless'].getErrorsMapper().bind(null, null);

            errors = result.validation_result.errors.map(errorMapper);

            BEM.DOM.replace(this.findElem('errors'), BEMHTML.apply({
                block: 'p-edit-vcard-headless',
                elem: 'errors',
                errors: errors
            }));

            this.findElem('errors').get(0).scrollIntoView();
        }
    },

    /**
     * Отправка ajax формы на сервер
     * @private
     */
    _submitForm: function() {
        var vcard,
            serialized;

        // помимо данных формы редактирования визитки, нужно собрать скрытые поля формы
        serialized = this._form
            .elem('hidden-input')
            .serializeArray()
            .reduce(function(res, item) {
                res[item.name] = item.value;

                return res;
            }, this._vcardForm.serialize('object'));

        vcard = this._convertVcardFormat(serialized);

        BEM.blocks['i-web-api-request'].vcards
            .saveVcard(u.consts('ulogin'), vcard)
            .then(this._onRequestDone.bind(this));
    }

});
