(function() {
    var errorMapper,
        labels = {
            'vcard.company_name': iget2('p-edit-vcard-headless', 'path-vcard-company_name', 'Название компании/ФИО'),
            'vcard.contact_person': iget2('p-edit-vcard-headless', 'path-vcard-contact_person','Контактное лицо'),
            'vcard.email': iget2('p-edit-vcard-headless', 'path-vcard-email','E-mail'),
            'vcard.ogrn': iget2('p-edit-vcard-headless', 'path-vcard-ogrn','ОГРН/ОГРНИП'),
            'vcard.work_time': iget2('p-edit-vcard-headless', 'path-vcard-work_time','Время работы'),
            'vcard.extra_message': iget2('p-edit-vcard-headless', 'path-vcard-extra_message','Подробнее о товаре/услуге'),
            'vcard.country': iget2('p-edit-vcard-headless', 'path-vcard-country','Страна'),
            'vcard.city': iget2('p-edit-vcard-headless', 'path-vcard-city','Город'),
            'vcard.street': iget2('p-edit-vcard-headless', 'path-vcard-street','Улица'),
            'vcard.house': iget2('p-edit-vcard-headless', 'path-vcard-house','Дом'),
            'vcard.build': iget2('p-edit-vcard-headless', 'path-vcard-build','Корпус'),
            'vcard.apart': iget2('p-edit-vcard-headless', 'path-vcard-apart','Офис'),
            'vcard.metro_id': iget2('p-edit-vcard-headless', 'path-vcard-metro_id','Метро'),
            'vcard.phone': iget2('p-edit-vcard-headless', 'path-vcard-phone','Телефон'),
            'vcard.phone.country_code': iget2('p-edit-vcard-headless', 'path-vcard-phone-country_code','Телефон/Код страны'),
            'vcard.phone.city_code': iget2('p-edit-vcard-headless', 'path-vcard-phone-city_code','Телефон/Код города'),
            'vcard.phone.phone_number': iget2('p-edit-vcard-headless', 'path-vcard-phone-phone_number','Телефон'),
            'vcard.phone.extension': iget2('p-edit-vcard-headless', 'path-vcard-phone-extension','Телефон/Добавочный'),
            'vcard.instant_messenger.type': iget2('p-edit-vcard-headless', 'path-vcard-instant_messenger-type','Интернет-пейджер'),
            'vcard.instant_messenger.login': iget2('p-edit-vcard-headless', 'path-vcard-instant_messenger-login','Интернет-пейджер'),
            'vcard.manual_point.x': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте'),
            'vcard.manual_point.y': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте'),
            'vcard.manual_point.x1': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте'),
            'vcard.manual_point.y1': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте'),
            'vcard.manual_point.x2': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте'),
            'vcard.manual_point.y2': iget2('p-edit-vcard-headless', 'path-vcard-manual_point','Положение на карте')
        };

    function getLabel(path) {
        return labels[path] || path;
    }

    u.register({
        'p-edit-vcard-headless': {
            getErrorsMapper: function() {
                return errorMapper || (errorMapper = u['p-edit-vcard-headless'].createErrorsMapper());
            },

            createErrorsMapper: function() {
                return u['web-api-errors'].makeErrorMapper(
                    function() {
                        return [
                            {
                                path: ['vcard'],
                                codes: [
                                    {
                                        code: 'DefectIds.CANNOT_BE_NULL',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-cant-be-null',
                                                'Не указано значение в поле "{label}".',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'StringDefectIds.CANNOT_BE_EMPTY',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-cant-be-empty',
                                                'Не указано значение в поле "{label}".',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'length-cant-be-more-than-max',
                                                'Значение в поле "{label}" не должно превышать {maxLength} символов.',
                                                { label: getLabel(err.path), maxLength: err.params.maxLength }
                                            );
                                        }
                                    },
                                    {
                                        code: 'DefectIds.MUST_CONTAIN_LETTERS',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-must-contains-letters-only',
                                                'В поле "{label}" можно использовать только буквы латинского, турецкого, русского, украинского, казахского и белорусского алфавитов.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-must-contains-letters-digits-punctuations-only',
                                                'В поле "{label}" можно использовать только буквы латинского, турецкого, русского, украинского, казахского и белорусского алфавита, цифры и знаки препинания.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-must-be-great-or-equal-than-min',
                                                'В поле "{label}" указано некорректное значение.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'value-must-be-less-or-equal-than-max',
                                                'В поле "{label}" указано некорректное значение.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['vcard', 'phone'],
                                codes: [
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_LENGTH_IS_INVALID',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'ENTIRE_PHONE_LENGTH_IS_INVALID',
                                                'В поле "{label}" указан неправильный формат номера телефона.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG',
                                                'В поле "{label}" указан неправильный формат номера телефона.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },

                                    // код страны
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_LONG',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'COUNTRY_CODE_IS_TOO_LONG',
                                                'Код страны должен содержать не более 5 символов, состоять из цифр и начинаться со знака "+" или "8".'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_SHORT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'COUNTRY_CODE_IS_TOO_SHORT',
                                                'Код страны должен содержать хотя бы один символ, состоять из цифр и начинаться со знака "+" или "8".'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.VoidDefectIds.COUNTRY_CODE_FORMAT_IS_INVALID',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'COUNTRY_CODE_FORMAT_IS_INVALID',
                                                'Код страны должен содержать от 1 до 5 символов, состоять из цифр и начинаться со знака "+" или "8".'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.VoidDefectIds.COUNTRY_CODE_MUST_START_WITH_PLUS',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'COUNTRY_CODE_MUST_START_WITH_PLUS',
                                                'Код страны должен начинаться со знака "+".'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.CityCodeDefectIds.COUNTRY_CODE_MUST_NOT_START_WITH_PLUS',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'COUNTRY_CODE_MUST_NOT_START_WITH_PLUS',
                                                'В поле "{label}" указано некорректное значение.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },

                                    // код города
                                    {
                                        code: '"PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_SHORT"',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'CITY_CODE_IS_TOO_SHORT',
                                                'Код города должен содержать хотя бы 1 символ, состоять только из цифр и быть не равным 0.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_LONG',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'CITY_CODE_IS_TOO_LONG',
                                                'Код города должен содержать не более 5 символов и состоять только из цифр.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.VoidDefectIds.CITY_CODE_FORMAT_IS_INVALID',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'CITY_CODE_FORMAT_IS_INVALID',
                                                'Код города должен содержать от 1 до 5 символов, состоять только из цифр и быть не равным 0.'
                                            );
                                        }
                                    },

                                    // номер телефона
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_SHORT',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'PHONE_NUMBER_IS_TOO_SHORT',
                                                'В поле "{label}" указан неправильный формат номера телефона.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_LONG',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'PHONE_NUMBER_IS_TOO_LONG',
                                                'В поле "{label}" указан неправильный формат номера телефона.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.VoidDefectIds.PHONE_NUMBER_FORMAT_IS_INVALID',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'PHONE_NUMBER_FORMAT_IS_INVALID',
                                                'В поле "{label}" указан неправильный формат номера телефона.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },

                                    // добавочный номер
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_SHORT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'EXTENSION_IS_TOO_SHORT',
                                                'Добавочный номер должен содержать хотя бы один символ.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_LONG',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'EXTENSION_IS_TOO_LONG',
                                                'Добавочный номер должен содержать не более 6 символов.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'PhoneValidator.VoidDefectIds.EXTENSION_FORMAT_IS_INVALID',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'EXTENSION_FORMAT_IS_INVALID',
                                                'Добавочный номер должен содержать от 1 до 6 символов и состоять только из цифр.'
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['vcard', 'email'],
                                codes: [
                                    {
                                        code: 'AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_INVALID_FORMAT',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'CONTACT_EMAIL_INVALID_FORMAT',
                                                'Поле "{label}" должно содержать email-адрес.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['vcard', 'instant_messenger'],
                                codes: [
                                    {
                                        code: 'InstantMessengerValidator.VoidDefectIds.LOGIN_IS_NULL',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_LOGIN_IS_NULL',
                                                'Не указано значение в поле "{label}".',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'InstantMessengerValidator.StringDefectIds.LOGIN_IS_TOO_LONG',
                                        message: function(obj, err) {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_LOGIN_IS_TOO_LONG',
                                                'В поле "{label}" указано некорректное значение.',
                                                { label: getLabel(err.path) }
                                            );
                                        }
                                    },
                                    {
                                        code: 'InstantMessengerValidator.VoidDefectIds.INVALID_ICQ_LOGIN_FORMAT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_INVALID_ICQ_LOGIN_FORMAT',
                                                'ICQ UIN должен содержать от 5 до 10 цифр и состоять из цифр и дефисов.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'InstantMessengerValidator.VoidDefectIds.INVALID_JABBER_LOGIN_FORMAT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_INVALID_JABBER_LOGIN_FORMAT',
                                                'Jabber-идентификатор должен содержать корректный email-адрес.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'InstantMessengerValidator.VoidDefectIds.INVALID_MAIL_AGENT_LOGIN_FORMAT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_INVALID_MAIL_AGENT_LOGIN_FORMAT',
                                                'Имя почтового ящика для Мail.Ru Агента должно содержать email-адрес с доменами mail.ru, inbox.ru, bk.ru, list.ru.'
                                            );
                                        }
                                    },
                                    {
                                        code: 'InstantMessengerValidator.VoidDefectIds.INVALID_SKYPE_OR_MSN_LOGIN_FORMAT',
                                        message: function() {
                                            return iget2(
                                                'p-edit-vcard-headless',
                                                'IM_INVALID_SKYPE_OR_MSN_LOGIN_FORMAT',
                                                'Логин Skype должен содержать email-адрес или имя, состоящее из букв, цифр и знаков пунктуации.'
                                            );
                                        }
                                    }
                                ]
                            }
                        ];
                    },

                    function(obj, err) {
                        return err.message || iget2('p-edit-vcard-headless',
                            'vcard-save-error',
                            'Ошибка при сохранении контактной информации. Пожалуйста, повторите позже');
                    });
            }
        }
    });

})();
