match(function() {
    return this.data.cmd === 'showFeedHistory';
})(

    block('app-main').mode('page-block')('p-feeds-history'),

    block('b-page').mode('title')(function() {
        return iget2('p-feeds-history', 'detalizaciya-oshibok-dlya-fida', 'Детализация ошибок для фида');
    })
);

block('p-feeds-history')(

    addJs()(true),

    content()(function() {
        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-80'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        right: [
                            {
                                block: 'b-page-title',
                                content: {
                                    elem: 'title',
                                    content: iget2('p-feeds-history', 'detalizaciya-oshibok-dlya-fida-100', 'Детализация ошибок для фида &laquo;{foo}&raquo;', {
                                        foo: u.escapeHTML(this.data.feed.name)
                                    })
                                }
                            },
                            {
                                block: 'p-feeds-history',
                                elem: 'description'
                            }
                        ],
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'l-page',
                mods: {
                    layout: '84'
                },
                content: [
                    {
                        elem: 'row',
                        center: {
                            block: 'b-feeds-history',
                            mix: {
                                block: 'p-feeds-history',
                                elem: 'feeds-history'
                            }
                        }
                    }
                ]
            }
        ];
    }),

    elem('description').content()(function() {
        return [
            {
                block: 'link',
                url: u.parseUrl(this.data.FORM.retpath).protocol !== 'javascript' && this.data.FORM.retpath ||
                    u.getUrl('showFeeds', {
                        ulogin: u.consts('ulogin')
                    }),
                content: iget2('p-feeds-history', 'vernutsya-k-spisku-fidov', 'Вернуться к списку фидов')
            }
        ];
    })
);
