BEM.DOM.decl('p-feeds-history', {

    onSetMod: {
        js: function() {
            BEM.MODEL.create('dm-feed-history');

            u.graspSelf.call(this, {
                _feedsHistory: 'b-feeds-history on feeds-history'
            });

            this.history = BEM.blocks.history.getInstance();
            this.location = BEM.blocks.location.getInstance();

            this.history.on('statechange', function(e, data) {
                this._updateState((data.state || data).url);
            }, this);

            this._feedsHistory.on('stateChange', function(e, data) {
                this._updateHistory(data);
            }, this);

            this._updateState();
        }
    },

    /**
     * Обновляет состояние блока детализации ошибок по текущему url
     * @param {String} [url]
     * @private
     */
    _updateState: function(url) {
        url || (url = this.location.getUri().toString());

        this._feedsHistory.updateState(u.parseUrl(url).query);
    },

    /**
     * Обновляет историю навигации
     * @private
     */
    _updateHistory: function(data) {
        var url = this.location.getUri();

        u._.keys(data).forEach(function(key) {
            url.deleteParam(key);

            typeof data[key] !== 'undefined' &&
                url.addParam(key, data[key]);
        });

        this.history.changeState('push', { url: url.toString() });
    }

});
