match(function() {
    return this.data.cmd === 'findUsersByDomain';
})(

    block('app-main').mode('page-block')('p-find-users-by-domain'),

    block('b-page').mode('title')(function() {
        return iget2('p-find-users-by-domain', 'poisk-polzovateley-po-domenu', 'Поиск пользователей по домену');
    })
);

block('p-find-users-by-domain')(

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: {
                        block: 'b-page-title',
                        content: {
                            elem: 'title',
                            content: iget2('p-find-users-by-domain', 'optovaya-blokirovka-spam-loginov', 'Оптовая блокировка спам-логинов')
                        }
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: [
                        {
                            block: 'tabs-menu',
                            mods: {
                                size: 'm',
                                theme: 'border-bottom',
                                layout: 'horiz'
                            },
                            content: [
                                {
                                    elem: 'tab',
                                    content: {
                                        block: 'link',
                                        mix: [{
                                            block: 'p-find-users-by-domain',
                                            elem: 'tab-link'
                                        }],
                                        url: u.getUrl('massBlockUsers'),
                                        content: iget2('p-find-users-by-domain', 'blokirovka-loginov', 'Блокировка логинов')
                                    }
                                },
                                {
                                    elem: 'tab',
                                    elemMods: {
                                        active: 'yes'
                                    },
                                    content: {
                                        block: 'link',
                                        mix: [{
                                            block: 'p-find-users-by-domain',
                                            elem: 'tab-link'
                                        }],
                                        url: u.getUrl('findUsersByDomain'),
                                        content: iget2('p-find-users-by-domain', 'poisk-loginov-po-domenam', 'Поиск логинов по доменам')
                                    }
                                }
                            ]
                        },
                        {
                            block: 'p-find-users-by-domain',
                            elem: 'form'
                        },
                        !!this.data.users && {
                            block: 'p-find-users-by-domain',
                            elem: 'users'
                        }
                    ]
                }
            ]
        };
    }),

    elem('form').content()(function() {
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'p-find-users-by-domain',
                elem: 'form'
            }],
            action: this.data.script,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'findUsersByDomain'
                }
            ],
            rows: [
                {
                    block: 'input',
                    mods: {
                        type: 'textarea'
                    },
                    name: 'domain_list',
                    placeholder: iget2('p-find-users-by-domain', 'vvedite-domeny-v-stolbik', 'Введите домены в столбик или в строчку через запятую'),
                    content: [
                        {
                            elem: 'label',
                            content: iget2('p-find-users-by-domain', 'poisk-loginov-po-domenam', 'Поиск логинов по доменам') + ':'
                        },
                        {
                            elem: 'control',
                            attrs: {
                                rows: '8'
                            }
                        }
                    ]
                },
                {
                    block: 'checkbox',
                    mods: {
                        size: 'm',
                        theme: 'normal'
                    },
                    checkboxAttrs: {
                        name: 'include_subdomains',
                        value: 1
                    },
                    text: iget2('p-find-users-by-domain', 'iskat-po-domenam-i-poddomenam', 'Искать по доменам и поддоменам')
                },
                {
                    block: 'checkbox',
                    mods: {
                        size: 'm',
                        theme: 'normal',
                        checked: 'yes'
                    },
                    checkboxAttrs: {
                        name: 'show_subdomains',
                        value: 1,
                    },
                    text: iget2('p-find-users-by-domain', 'pokazyvat-poddomeni', 'Показывать поддомены')
                },
                {
                    block: 'button',
                    mix: {
                        block: 'p-find-users-by-domain',
                        elem: 'submit'
                    },
                    type: 'submit',
                    content: iget2('p-find-users-by-domain', 'nayti', 'Найти')
                }
            ]
        };
    }),

    elem('users').content()(function() {

        return this.data.users.map(function(user) {
            return {
                block: 'p-find-users-by-domain',
                elem: 'user-link',
                content: [
                    {
                        block: 'link',
                        url: u.getUrl('showCamps', {
                            ulogin: user.ulogin
                        }),
                        content: user.ulogin
                    },
                    {
                        elem: 'label',
                        content: user.domains
                    }
                ]
            };
        });
    })
);
