match(function() {
    return this.data.cmd === 'showDna' || this.data.cmd === 'showDnaPb';
})(

    block('app-main')(
        mode('page-block')('p-grid'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false)
    ),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            return applyNext({
                pageParams: {
                    auxParams: {
                        showCampStat: null,
                        camp_count_for_transfer: null,
                        camp_count_with_sum: null,
                        exists_campaigns_for_edit: null,
                        be_shows: null,
                        cid_for_manage_vcards: null,
                        agencyLogin: null,
                        campsExist: null,
                        // данные из cansvn s
                        edit_camp: null,
                        transfer_money: null,
                        payCampaign: null,
                        showuid: null
                    }
                }
            });
        }),

        elem('static-css').replace()(function() {
            return [
                this.addDnaMainStyles()
            ];
        }),

        elem('static-js').replace()(function() {
            var data = this.data,
                devInfo = u.createDevInfo(data),
                tagsAllowed = data.tags_allowed === 'Yes';

            if (data.is_fast_show_dna) {
                var dnaBootstrapParams = {
                    devInfo: devInfo,
                    abBoxes: data.ab_boxes,
                    cspNonce: data.csp_nonce,
                    perlReqId: data.reqid,
                    page: data.cmd,
                    csrfToken: data.csrf_token,
                    clientUid: data.uid,
                    operatorUid: data.UID,
                    tagsAllowed: tagsAllowed,
                    clientFeatures: u.consts('clientFeaturesAll'),
                    operatorFeatures: u.consts('operatorFeaturesAll'),
                    infoblockTeasersUrl: data.infoblock_teasers_url,
                    collectingVerifiedPhonesDisabledForCountries: data.collecting_verified_phones_disabled_for_countries,
                    login: data.login,
                    loginRights: data.login_rights,
                    loginFromBlackbox: data.uname,
                    isBeta: data.is_beta,
                    isPublicDomain: data.is_public,
                    isMobile: data.uatraits.isMobile,
                    isTablet: data.uatraits.isTablet,
                    isFastShowDna: Boolean(data.is_fast_show_dna),
                    isLoginBlocked: Boolean(data.is_blocked),
                    isInternalNetwork: Boolean(data.is_internal_ip),
                    userInfo: u.getUserInfo(data)
                };
                var dnaBootstrapScript = 'window.dnaBootstrap(' + safeStringify(dnaBootstrapParams) + ');';

                return [].concat(
                    this.addFontToPreloadLinks(),
                    this.addBeforeJsInitScripts({ observeDOMNode: '#dna-root' }),
                    this.addUtilityScripts(),
                    this.addDnaMainScript(),
                    {
                        elem: 'js',
                        content: dnaBootstrapScript
                    },
                    this.addAfterJsInitScripts(),
                    this.addCtxDumpScript()
                );
            }

            var officeCity = u.getOfficeCityFromData(data),
                officeContacts = applyCtx({ block: 'i-office-contacts' }).offices[officeCity],
                rootProps,
                storeParams;

            rootProps = {
                login: data.login,
                isInternalNetwork: data.is_internal_ip,
                gridAllowed: data.grid_allowed,
                isGridEnabled: data.is_grid_enabled,
                enableRecommendations: data.enable_recommendations,
                enableSidebar: Boolean(data.is_dna_sidebar_enabled),
                isWebvisorEnabled: Boolean(data.is_webvisor_enabled),
                isSidebarOptimizeEnable: Boolean(data.is_enable_sidebar_optimize),
                minusPhraseLibraryEnabled: Boolean(data.is_minus_words_lib_enabled),
                isGlobalWarningEnabled: false, // DIRECT-121096 — здесь можно включить глобальное предупреждение в новом интерфейсе
                isCollectingVerifiedPhonesEnabled: Boolean(data.enable_collecting_verified_phones) &&
                    Boolean(data.collecting_verified_phones_mutable),
                tagsAllowed: tagsAllowed,
                logParams: {
                    isClient: data.login_rights.role === 'client' && u.consts('isMy'),
                },
                isHeaderAvailable: true,
                domainsReportEnabled: data.billing_order_domains_offline_report_enabled,
                kpiReportEnabled: data.agency_kpi_offline_report_enabled,
                dealsEnabled: !hasLoginRights('is_agency_limited') &&
                    (hasLoginRights('super_control') || data.cpm_deals_enabled_client),
                dealsReadonly: !hasLoginRights('super_control', 'agency_control'),
                isServiceWorkerAllowed: Boolean(data.is_service_worker_allowed),
                videoEditorEnabled: data.video_constructor_enabled,
                abBoxesCrypted: data.ab_boxes_crypted ? data.ab_boxes_crypted : undefined,
                isDnaHeaderAndSidebarEnabled: Boolean(u.consts('rights').isDnaHeaderAndSidebarEnabled),
                isVCCreateFromScratchEnabled: Boolean(data.video_constructor_create_from_scratch_enabled),
                isVCFeedEnabled: Boolean(data.video_constructor_feed_enabled),
                isCampaignPageEnabled: Boolean(
                    data.is_new_campaign_page_enabled || data.is_beta && data.COOKIES.new_show_camp
                ),
                isUniversalCampaignsEnabled: Boolean(data.is_universal_campaigns_enabled),
                isCashbackPageEnabled: Boolean(data.isCashbackAvailable),
                isUcDesignEnabled: Boolean(data.is_uc_design_enabled),
                isUcGridDesignEnabled: Boolean(data.is_uc_grid_design_enabled),
                isMetrikaLoadInHead: u.hasClientFeature('metrika_load_in_head')
            };

            storeParams = {
                loginFromBlackbox: data.uname,
                isInternalNetwork: data.is_internal_ip,
                csrfToken: this.data.csrf_token,
                perlReqId: data.reqid,
                page: data.cmd,
                isPublicDomain: data.is_public,
                isTablet: data.uatraits.isTablet,
                isMobile: data.uatraits.isMobile,
                login: data.login,
                isLoginBlocked: Boolean(data.is_blocked),
                devInfo: devInfo,
                tagsAllowed: tagsAllowed,
                role: u.getRoleNameForHead(data.login_rights),
                availableCampaignsTypes: u['b-choose-campaign-type'].dnaCampaignTypes(),
                officeContacts: officeContacts,
                cspNonce: data.csp_nonce,
                isSidebarOptimizeEnable: Boolean(data.is_enable_sidebar_optimize),
                infoblockTeasersUrl: data.infoblock_teasers_url,
                isGridEnabled: data.is_grid_enabled,
                isHideOldShowCamps: data.is_hide_old_show_camps,
                isShowDnaByDefault: Boolean(data.is_show_dna_by_default),
                abBoxes: data.ab_boxes ? data.ab_boxes : undefined,
                UID: data.UID,
                isNewPaymentWorkflowEnabled: Boolean(+data.is_new_payment_workflow_enabled),
                isUcDesignEnabled: Boolean(data.is_uc_design_enabled),
                isUcGridDesignEnabled: Boolean(data.is_uc_grid_design_enabled),
                isCompressColumnWidthsEnabled: u.hasClientFeature('compress_column_widths'),
                isCompressColumnWidthsForUsersWithUCDesignEnabled: u.hasClientFeature('compress_column_widths_for_users_with_uc_design'),
                clientFeatures: u.consts('clientFeaturesAll'),
                operatorFeatures: u.consts('operatorFeaturesAll')
            };

            var initStore = 'dna.components.Root.initStore(' + safeStringify(storeParams) + ');';
            var renderReact = 'var root=document.getElementById("app-wrapper");' +
                'if(root){' +
                'var elem=dna.reactCreateElement(dna.components.Root,' + safeStringify(rootProps) + ');' +
                'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3070\');' +
                'dna.reactDOMRender(elem,root);' +
                'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3036\');' +
                '}';

            return [
                this.addFontToPreloadLinks(),
                this.addBeforeJsInitScripts({ observeDOMNode: '#dna-root' }),
                this.addUtilityScripts(),
                this.addDnaMainScript(),
                {
                    elem: 'js',
                    content: '(function() {' + initStore + '})()'
                },
                {
                    elem: 'js',
                    content: '(function(){' + renderReact + '})()'
                },
                this.addAfterJsInitScripts(),
                this.addCtxDumpScript()
            ];
        }),

        mode('head')(function() {
            return [].concat(
                u.getMetrikaPreloadScript(this.data.is_webvisor_enabled),
                // удалить после проведения эксперимента
                u.getMetrikaScript(this.data.is_webvisor_enabled, this.data.csp_nonce),
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-timing'
                    })
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-error-counter'
                    })
                },
                this.addDnaInlineScript(),
                {
                    elem: 'css',
                    content: 'body { margin:0; padding:0; }'
                },
                this.addFavicons(),
                this.addPreloadLinks()
            );
        }),

        elem('body').replace()(function() {
            return [
                { elem: 'logos' },
                { elem: 'old-browsers' },
                { elem: 'content' },
                { elem: 'static-css' },
                { elem: 'static-js' }
            ];
        })
    )
);

block('p-grid')(
    content()(function() {
        return {
            elem: 'app-wrapper',
            attrs: {
                id: 'app-wrapper',
                style: 'height: 100vh',
            },
            content: [
                {
                    block: 'b-header-skeleton',
                    isDirectBirthdayRebrandingEnabled: u.hasClientFeature('direct_birthday_rebranding')
                },
                {
                    block: 'b-sidebar-skeleton',
                    attrs: {
                        style: 'height: 100%;'
                    },
                    isUcDesignEnabled: Boolean(this.data.is_uc_grid_design_enabled),
                    isDirectBirthdayRebrandingEnabled: u.hasClientFeature('direct_birthday_rebranding')
                }
            ]
        };
    })
);
