block('p-internal-search').elem('table-cell-content')(

    elemMod('key', 'campaign').content()(function() {
        var campaign = this.ctx.campaign,
            // eslint-disable-next-line require-iget2
            orderIdDescription = campaign.OrderID > 0 ? ', &nbsp;БК:&nbsp;' + campaign.OrderID : '';

        return [
            {
                block: 'p-internal-search',
                elem: 'title',
                elemMods: {
                    'has-actions': campaign.actions ? 'yes' : undefined
                },
                content: [
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        url: u['p-internal-search'].createCampaignUrl(campaign.login, campaign.cid),
                        content: campaign.name
                    },
                    '(', '№&nbsp;', campaign.cid, orderIdDescription, ')'
                ]
            },
            {
                block: 'p-internal-search',
                elem: 'actions',
                elemMods: { type: 'campaign' },
                rowNum: this.ctx.rowNum,
                campaign: campaign
            }
        ];
    }),

    elemMod('key', 'group').content()(function() {
        var group = this.ctx.group;

        return [
            {
                block: 'p-internal-search',
                elem: 'title',
                content: [
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        url: u['p-internal-search'].createAdgroupUrl(group.login, group.cid, group.pid),
                        content: group.group_name
                    },
                    '(', '№&nbsp;', group.pid, ')'
                ]
            }
        ];
    }),

    elemMod('key', 'ad').content()(function() {
        var ad = this.ctx.ad,
            // eslint-disable-next-line require-iget2
            bannerIdDescription = ad.BannerID > 0 ? ', &nbsp;БК:&nbsp;' + ad.BannerID : '';

        return [
            {
                block: 'p-internal-search',
                elem: 'title',
                content: [
                    {
                        block: 'link',
                        mods: { theme: 'normal' },
                        url: u['p-internal-search'].createAdUrl(ad.login, ad.cid, ad.bid),
                        content: ad.description
                    },
                    '(', '№&nbsp;', ad.bid, bannerIdDescription, ')'
                ]
            }
        ];
    }),

    elemMod('key', 'status').content()(function() {
        var campaign = this.ctx.campaign;

        return campaign.status.text;
    })

);
