block('p-internal-search')(

    elem('paranja').content()({
        block: 'spin',
        js: true,
        mods: {
            progress: 'yes',
            theme: 'gray-48'
        },
        mix: { block: 'p-internal-search', elem: 'paranja-spin' }
    }),

    elem('found').content()(function() {
        return [
            { block: 'p-internal-search', elem: 'paranja' },
            {
                block: 'b-data-table',
                mix: [
                    { block: 'b-style-table', mods: { theme: 'gray-list' } },
                    { block: 'p-internal-search', elem: 'banners-table' }
                ],
                mixes: {
                    row: [
                        { block: 'b-style-table', elem: 'row' },
                        { block: 'p-internal-search', elem: 'result-row' }
                    ],
                    headerRow: [{ block: 'b-style-table', elem: 'head' }],
                    cell: function(key) {
                        return [
                            { block: 'b-style-table', elem: 'cell' },
                            {
                                block: 'p-internal-search',
                                elem: 'table-cell',
                                elemMods: { key: u.beminize(key) }
                            }
                        ];
                    },
                    headerCell: function(key) {
                        return [{ block: 'b-style-table', elem: 'cell' }];
                    }
                },
                columns: this.ctx.columns,
                rows: this.ctx.rows
            }
        ]
    }),

    elem('warning').content()(function() {
        return {
            block: 'icon-text',
            mods: { size: 'xs', theme: 'alert' },
            text: u.escapeHTML(this.ctx.warning)
        };
    }),

    elem('empty-products').content()(function() {
        var links = this.ctx.emptyProducts.map(function(emptyProduct) {
            return {
                block: 'b-link',
                url: u['p-internal-search'].createProductUrl(emptyProduct.login),
                content: u.escapeHTML(emptyProduct.product_name)
            };
        });

        return {
            block: 'icon-text',
            mods: { size: 'xs', theme: 'info' },
            text: [
                iget2('p-internal-search', '', 'В этих продуктах кампаний не нашлось'),
                ': ',
                u.spacer(links, ', '),
                '.'
            ]
        };
    })
);
