match(function() {
    return ['showInternalAdsSearchPage', 'internalAdsSearch'].includes(this.data.cmd);
})(
    block('app-main').mode('page-block')('p-internal-search'),

    block('b-page').mode('title')(function() {
        return iget2('p-internal-search', 'internal-search', 'Поиск внутренней рекламы');
    })
);

block('p-internal-search')(
    def()(function() {
        var isResultPage = this.data.cmd === 'internalAdsSearch';

        return applyNext({
            _isResultPage: isResultPage,
            'mods.loading': isResultPage ? 'yes' : ''
        });
    }),

    js()(function() {
        return this._isResultPage;
    }),

    mode('columns-campaigns')(function() {
        return [
            {
                key: 'name',
                title: iget2('p-internal-search', 'campaign-name-column', 'Кампания'),
                transformData: function(campaign, index) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'campaign', 'row-num': index },
                        rowNum: index,
                        campaign: campaign
                    };
                }
            },
            {
                key: 'type',
                title: iget2('p-internal-search', 'type-column', 'Тип'),
                transformData: function(campaign) {
                    return {
                        internal_distrib: iget2('p-internal-search', 'internal-distrib', 'Дистрибуционная'),
                        internal_free: iget2('p-internal-search', 'internal-free', 'Бесплатная'),
                        internal_autobudget: iget2('p-internal-search', 'internal-autobudget', 'Автобюджетная'),
                    }[campaign.type];
                }
            },
            {
                key: 'place_id',
                title: iget2('p-internal-search', 'place-id-column', 'Плейс')
            },
            {
                key: 'product_name',
                title: iget2('p-internal-search', 'product-name-column', 'Продукт'),
                transformData: function(campaign) {
                    return !campaign.product_name ? '&mdash;' : [
                        {
                            block: 'link',
                            mods: { theme: 'normal' },
                            url: u['p-internal-search'].createProductUrl(campaign.login),
                            content: campaign.product_name
                        }
                    ];
                }
            },
            {
                key: 'status',
                title: iget2('p-internal-search', 'status-column', 'Состояние'),
                transformData: function(campaign, index) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'status', 'row-num': index },
                        campaign: campaign
                    };
                }
            }
        ];
    }),

    mode('columns-adgroups')(function() {
        return [
            {
                key: 'pid',
                title: iget2('p-internal-search', 'pid-column', 'Группа'),
                transformData: function(adgroup) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'group' },
                        group: adgroup
                    };
                }
            },
            {
                key: 'place_id',
                title: iget2('p-internal-search', 'place-id-column', 'Плейс')
            },
            {
                key: 'campaign_name',
                title: iget2('p-internal-search', 'campaign-name-column', 'Кампания'),
                transformData: function(adgroup) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'campaign' },
                        campaign: {
                            name: adgroup.campaign_name,
                            login: adgroup.login,
                            cid: adgroup.cid
                        }
                    };
                }
            },
            {
                key: 'product_name',
                title: iget2('p-internal-search', 'product-name-column', 'Продукт'),
                transformData: function(adgroup) {
                    return !adgroup.product_name ? '&mdash;' : [
                        {
                            block: 'link',
                            mods: { theme: 'normal' },
                            url: u['p-internal-search'].createProductUrl(adgroup.login),
                            content: adgroup.product_name
                        }
                    ];
                }
            }
        ];
    }),

    mode('columns-ads')(function() {
        return [
            {
                key: 'bid',
                title: iget2('p-internal-search', 'bid-column', 'Объявление'),
                transformData: function(ad) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'ad' },
                        ad: ad
                    };
                }
            },
            {
                key: 'place_id',
                title: iget2('p-internal-search', 'place-id-column', 'Плейс')
            },
            {
                key: 'pid',
                title: iget2('p-internal-search', 'pid-column', 'Группа'),
                transformData: function(ad) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'group' },
                        group: {
                            group_name: ad.group_name,
                            login: ad.login,
                            cid: ad.cid,
                            pid: ad.pid
                        }
                    };
                }
            },
            {
                key: 'name',
                title: iget2('p-internal-search', 'campaign-name-column', 'Кампания'),
                transformData: function(ad) {
                    return {
                        block: 'p-internal-search',
                        elem: 'table-cell-content',
                        elemMods: { key: 'campaign' },
                        campaign: {
                            name: ad.campaign_name,
                            login: ad.login,
                            cid: ad.cid
                        }
                    };
                }
            },
            {
                key: 'product_name',
                title: iget2('p-internal-search', 'product-name-column', 'Продукт'),
                transformData: function(ad) {
                    return !ad.product_name ? '&mdash;' : [
                        {
                            block: 'link',
                            mods: { theme: 'normal' },
                            url: u['p-internal-search'].createProductUrl(ad.login),
                            content: ad.product_name
                        }
                    ];
                }
            }
        ];
    }),

    mode('warnings')(function() {
        var warnings = this.data.warnings;
        if (!warnings || warnings.length === 0) {
            return [];
        }

        return warnings.map(function(warning) {
            return {
                block: 'p-internal-search',
                elem: 'warning',
                warning: warning
            }
        });
    }),

    mode('empty-products')(function() {
        var emptyProducts = this.data.info_for_empty_products;
        if (!emptyProducts || emptyProducts.length === 0) {
            return [];
        }

        return {
            block: 'p-internal-search',
            elem: 'empty-products',
            emptyProducts: emptyProducts
        }
    }),

    mode('found-items')(function() {
        var campaigns = this.data.campaigns;
        var adgroups = this.data.adgroups;
        var ads = this.data.ads;

        if (campaigns && campaigns.length > 0) {
            return {
                columns: apply('columns-campaigns'),
                rows: campaigns
            };
        }

        if (adgroups && adgroups.length > 0) {
            return {
                columns: apply('columns-adgroups'),
                rows: adgroups
            };
        }

        if (ads && ads.length > 0) {
            return {
                columns: apply('columns-ads'),
                rows: ads
            };
        }
    }),

    mode('search-form')(function() {
        return {
            block: 'b-internal-search-form',
            mix: { block: 'p-internal-search', elem: 'form' }
        };
    }),

    mode('search-result')(function() {
        if (!this._isResultPage) {
            return;
        }

        var notices = [
            apply('warnings'),
            apply('empty-products')
        ];

        var found = apply('found-items');

        if (found) {
            return notices.concat([{
                block: 'p-internal-search',
                elem: 'found',
                columns: found.columns,
                rows: found.rows
            }]);
        }

        return notices.concat([{
            block: 'p-internal-search',
            elem: 'nothing-found'
        }]);
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-80'
            },
            content: {
                elem: 'row',
                left: true,
                right: [
                    {
                        block: 'b-page-title',
                        mix: { block: 'p-internal-search', elem: 'title' },
                        title: iget2('p-internal-search', 'internal-search', 'Поиск внутренней рекламы')
                    },
                    {
                        block: 'p-internal-search',
                        elem: 'container',
                        content: [
                            apply('search-form'),
                            apply('search-result')
                        ]
                    }
                ]
            }
        };
    })

);
