BEM.DOM.decl('p-internal-search', {

    onSetMod: {
        js: {
            inited: function() {
                this._subscriptions = BEM.create('i-subscription-manager');

                this._spinner = this.findBlockOn('paranja-spin', 'spin');
                this._form = this.findBlockOn('form', 'b-internal-search-form');

                this.setMod('loading', 'no');

                this._subscriptions.on(this._form, 'submit', function() {
                    this.setMod('loading', 'yes');
                }, this);
            }
        },
        loading: {
            yes: function() {
                this._spinner && this._spinner.setMod('progress', 'yes');
            },
            no: function() {
                this._spinner && this._spinner.delMod('progress');
            }
        }
    },

    destruct: function() {
        this._subscriptions.dispose();
        this._subscriptions.destruct();

        this.__base.apply(this, arguments);
    },

    _successAction: function(data, params) {
        var result = data.result,
            error = data.error || iget2('p-internal-search', 'unknown-error', 'Произошла непредвиденная ошибка.');

        if (!result) {
            BEM.blocks['b-confirm'].alert(error);

            return;
        }

        if (params.type === 'campaign') {
            this._processCampaignAction(
                result.length > 0 ? result[0] : null,
                params.rowNum
            );
        }
    },

    _failureAction: function() {
        var error = iget2('p-internal-search', 'request-error', 'Ошибка запроса. Попробуйте ещё раз.');

        BEM.blocks['b-confirm'].alert(error);
    },

    _processCampaignAction: function(campaign, rowNum) {
        var root = this.findElem('table-cell-content', 'row-num', rowNum);

        // Отсутствие кампании как результат удаление: удаляем из таблицы
        if (!campaign) {
            var isLastRow = this.findElem('result-row').length === 1;

            // Если строка не последняя, то просто удаляем
            // Если строка последняя, то перерисовываем таблицу
            if (!isLastRow) {
                BEM.DOM.destruct(this.findBlockOutside(root, 'p-internal-search__result-row').domElem);
            } else {
                this._spinner = null;

                BEM.DOM.replace(this.elem('found'), BEMHTML.apply({
                    block: 'p-internal-search',
                    elem: 'nothing-found',
                    tech: 'bemhtml'
                }));
            }
        } else {
            BEM.DOM.replace(this.findElem(root, 'table-cell-content', 'key', 'campaign'), BEMHTML.apply({
                block: 'p-internal-search',
                elem: 'table-cell-content',
                elemMods: { key: 'campaign', 'row-num': rowNum },
                rowNum: rowNum,
                campaign: campaign
            }));

            BEM.DOM.replace(this.findElem(root, 'table-cell-content', 'key', 'status'), BEMHTML.apply({
                block: 'p-internal-search',
                elem: 'table-cell-content',
                elemMods: { key: 'status', 'row-num': rowNum },
                campaign: campaign
            }));
        }
    }

}, {

    live: function() {
        this.liveBindTo('action', 'click', function(e) {
            e.preventDefault();

            var params = this.elemParams(e.data.domElem);

            if (!params.url || !params.type) {
                return;
            }

            this.setMod('loading', 'yes');

            BEM
                .create('i-request_type_ajax', {
                    url: params.url,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    callbackCtx: this
                })
                .get({}, function(data) {
                    this._successAction(data, params);

                    this.setMod('loading', 'no');
                }, function() {
                    this._failureAction();

                    this.setMod('loading', 'no');
                });
        });

        return false;
    }

});
