match(function() {
    return this.data.cmd === 'listWarnPlace';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data;

            if (data.FORM.ws_done != 0 && data.FORM.ws_done != 1) {
                data.FORM.ws_done = 0;
            }

            //приводим safe-string -> string
            ['ws_cid', 'ws_client', 'sort'].forEach(function(key) {
                if (data.FORM[key]) {
                    data.FORM[key] = data.FORM[key].toString();
                }
            });
            (data.phlist || []).forEach(function(phrase) {
                ['fio', 'mafio'].forEach(function(key) {
                    if (phrase[key]) {
                        phrase[key] = phrase[key].toString();
                    }
                });
            });

            data.isClient = !(hasLoginRights('manager_control', 'agency_control', 'super_control') ||
                data.UID != data.uid);

            return data;
        }),

        mode('page-block')('p-list-warn-place')

    ),

    block('b-page').mode('title')(function() {
        return iget2('p-list-warn-place', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам');
    })

);

block('p-list-warn-place')(
    content()(function() {
        var data = this.data,
            FORM = data.FORM,
            maybeDone = FORM.ws_place == '0' &&
            FORM.ws_time == '1d' &&
            FORM.ws_cid == '0' &&
            FORM.ws_done == '0';

        return {
            block: 'l-page',
            mods: {
                layout: '84'
            },
            content: [
                {
                    elem: 'row',
                    center: {
                        block: 'b-page-title',
                        mix: [{
                            block: 'p-list-warn-place',
                            elem: 'title'
                        }],
                        content: {
                            elem: 'title',
                            content: iget2('p-list-warn-place', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам')
                        }
                    }
                },
                {
                    elem: 'row',
                    center: {
                        block: 'p-list-warn-place',
                        elem: 'filter-form'
                    }
                },
                {
                    elem: 'row',
                    center: data.phlist && data.phlist.length ?
                        {
                            block: 'p-list-warn-place',
                            elem: 'phrases-table'
                        } :
                        {
                            block: 'p-list-warn-place',
                            elem: 'hints',
                            content: [
                                {
                                    elem: 'no-phrases'
                                },
                                maybeDone && {
                                    elem: 'maybe-done'
                                }
                            ]
                        }
                }
            ]
        };
    }),

    elem('filter-form').content()(function() {
        return {
            block: 'b-list-warn-place-filter-form',
            data: this.extend({
                script: this.data.script,
                isClient: this.data.isClient,
                camps: (this.data.all_camps || []).sort(function(a, b) {
                    return a.cid > b.cid ? 1 : -1;
                }),
                clients: (this.data.all_clients || []).sort(function(a, b) {
                    return a.FIO > b.FIO ? 1 : -1;
                }),
                uid_par: this.data.uid_par
            }, ['sort', 'reverse', 'ws_place', 'ws_time', 'ws_cid', 'ws_done', 'ws_client'].reduce(function(res, key) {
                if (this.data.FORM[key]) {
                    res[key] = this.data.FORM[key].toString();
                }

                return res;
            }.bind(this), {}))
        };
    }),

    elem('phrases-table').content()(function() {
        return {
            block: 'b-list-warn-place-phrases-table',
            data: this.extend({
                script: this.data.script,
                isClient: this.data.isClient,
                uid_par: this.data.uid_par,
                phrases: this.data.phlist
            }, ['sort', 'reverse', 'ws_place', 'ws_time', 'ws_cid', 'ws_done', 'ws_client'].reduce(function(res, key) {
                if (this.data.FORM[key]) {
                    res[key] = this.data.FORM[key].toString();
                }

                return res;
            }.bind(this), {}))
        };
    }),

    elem('no-phrases').content()(function() {
        return iget2('p-list-warn-place', 'dannye-udovletvoryayushchie-vsem-usloviyam', 'Данные, удовлетворяющие всем условиям, не найдены.');
    }),

    elem('maybe-done').content()(function() {
        return iget2(
            'p-list-warn-place',
            'vozmozhno-obyavleniya-kotorye-byli',
            'Возможно, объявления, которые были вытеснены из позиции, вернулись на прежнее место, и соответствующие фразы находятся теперь в этом мониторинге в разделе &laquoпроверенные&raquo.'
        );
    })
);
