block('p-manage-clients').elem('clients').content()(function() {
    var repsHash = this.ctx.repsHash,
        searchStrReg = this.ctx.searchStr && (new RegExp('(' + u.escape.regExp(this.ctx.searchStr) + ')', 'gi')),

        highlight = function(str) {
            //находим все вхождения в строке по регекспу и заменяем их на элемент с подсветкой
            return searchStrReg ?
                str.split(searchStrReg).map(function(item, i) {
                    return i % 2 ? // каждый четный элемент будет являться строкой вхождения
                    {
                        block: 'p-manage-clients',
                        elem: 'highlighter',
                        content: item
                    } :
                        item;
                }) :
                str;
        };

    return {
        block: 'b-data-table',
        mods: {
            'has-num-column': 'yes',
            sortable: this.allFilteredClientsShownOnPage ? 'client' : 'server'
        },
        mix: [{
            block: 'b-style-table',
            mods: { theme: 'gray-list' }
        }],
        sortBy: this.ctx.sortBy,
        startIndex: this.ctx.startIndex,
        columns: [
            {
                key: 'checkbox',
                disableSorted: true,
                transformData: function(row) {
                    var repsResult = [],
                        uids = 'none';

                    (row.limited_agency || []).forEach(function(lagency) {
                        if (repsHash[lagency]) {
                            repsResult.push(repsHash[lagency]);
                        }
                    });

                    if (repsResult.length) {
                        uids = repsResult.map(function(rep) {
                            return rep.uid;
                        });
                    }

                    return {
                        block: 'checkbox',
                        mix: [{
                            block: 'p-manage-clients',
                            elem: 'client-checkbox',
                            elemMods: {
                                client: row.login
                            }
                        }],
                        js: {
                            uids: uids
                        }
                    };
                }
            },
            {
                key: 'login',
                title: iget2('p-manage-clients', 'login', 'Логин'),
                transformData: function(row) {
                    return highlight(row.login);
                }
            },
            {
                key: 'FIO',
                title: iget2('p-manage-clients', 'fio', 'ФИО'),
                transformData: function(row) {
                    return highlight(row.FIO);
                }
            },
            {
                key: 'email',
                title: iget2('p-manage-clients', 'e-mail', 'E-mail'),
                transformData: function(row) {
                    return {
                        block: 'link',
                        url: 'mailto:' + row.email,
                        content: highlight(row.email)
                    };
                }
            },
            {
                key: 'limited_agency',
                title: iget2('p-manage-clients', 'predstavitel', 'Представитель'),
                transformData: function(row) {
                    var repsResult = [];

                    (row.limited_agency || []).forEach(function(lagency) {
                        if (repsHash[lagency]) {
                            repsResult.push(highlight(repsHash[lagency].fio));
                        }
                    });

                    return repsResult.length ?
                        u.spacer(repsResult, ', ') :
                        '&mdash;';
                }
            }
        ],
        mixes: {
            row: function(row) {
                var repsResult = [],
                    uids = 'none',
                    result = [
                        {
                            block: 'b-style-table',
                            elem: 'row'
                        }
                    ];

                (row.limited_agency || []).forEach(function(lagency) {
                    if (repsHash[lagency]) {
                        repsResult.push(repsHash[lagency]);
                    }
                });

                if (repsResult.length) {
                    uids = repsResult.map(function(rep) {
                        return rep.uid;
                    });
                }

                if (uids !== 'none') {
                    uids.forEach(function(uid) {
                        result.push({
                            block: 'p-manage-clients',
                            elem: 'client-row',
                            elemMods: { uid: uid },
                            js: {
                                campsNum: row.camps_cnt
                            }
                        });
                    });
                } else {
                    result.push({
                        block: 'p-manage-clients',
                        elem: 'client-row',
                        elemMods: { uid: 'none' },
                        js: {
                            campsNum: row.camps_cnt
                        }
                    });
                }

                return result;
            },
            headerRow: [{
                block: 'b-style-table',
                elem: 'head'
            }],
            cell: function(key) {

                return [
                    {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    {
                        block: 'p-manage-clients',
                        elem: 'client-cell',
                        elemMods: { key: key || 'num' }
                    }
                ];
            },
            headerCell: function(key) {

                return [
                    {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    {
                        block: 'p-manage-clients',
                        elem: 'client-column',
                        elemMods: { key: key || 'num' }
                    }
                ];
            }
        },
        rows: this.ctx.clients || []
    };
});
