match(function() {
    return this.data.cmd === 'manageClientsOfAgency';
})(

    block('app-main').mode('page-block')('p-manage-clients'),

    block('b-page').mode('title')(function() {
        return iget2('p-manage-clients', 'naznachenie-klientov-predstavitelyam-agentstva', 'Назначение клиентов представителям агентства');
    })

);

block('p-manage-clients')(

    def()(function() {
        var clientsPerPageQuantity = 1000,
            data = this.data,
            allClientsShownOnPage = data.num_subclients_total <= clientsPerPageQuantity,
            isOnSearchResult = this.data.FORM.search_substring;

        return applyNext({
            'ctx.mods': u._.extend(this.ctx.mods || {}, {
                type: (allClientsShownOnPage && !isOnSearchResult) ? '' : 'backend-filters',
                'no-data': data.clients.length ? '' : 'yes'
            }),
            clientsPerPageQuantity: clientsPerPageQuantity,
            allClientsShownOnPage: allClientsShownOnPage,
            allFilteredClientsShownOnPage: data.num_subclients_filtered <= clientsPerPageQuantity
        });
    }),

    addJs().match(function() {
        return this.data.limited_agency_reps;
    }).match(function() {
        return !!this.data.limited_agency_reps.length;
    })(function() {

        return {
            canShareClient: u._.contains(this.data.features_enabled_for_client_all, 'NEW_LIM_REP_SCHEMA_SHARE_CLIENT'),
            reps: this.data.limited_agency_reps.reduce(function(reps, rep) {
                reps[rep.uid] = {
                    clientsNum: +rep.clients_cnt,
                    campsNum: +rep.camps_cnt,
                    email: rep.email,
                    phone: rep.phone,
                    login: rep.login,
                    fio: rep.FIO,
                    uid: rep.uid
                };

                return reps;
            }, {})
        };
    }),

    content()(function() {
        var data = this.data,
            form = data.FORM,
            selectedAgency = form.selected_agency,
            reps = data.limited_agency_reps,
            firstRep = reps && reps[0],
            currentRep,

            repsHash = firstRep && reps.reduce(function(hash, rep) {
                hash[rep.login] = {
                    fio: rep.FIO && rep.FIO.toString(),
                    uid: rep.uid
                };

                if (rep.login == selectedAgency) {
                    currentRep = rep;
                }

                return hash;
            }, {});

        !currentRep && (currentRep = firstRep);

        return {
            block: 'l-page',
            mix: [{
                block: 'p-manage-clients',
                elem: 'layout'
            }],
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: [
                        !hasLoginRights('is_agency_chief_lim_rep') && {
                            block: 'p-manage-clients',
                            elem: 'link',
                            content: {
                                block: 'link',
                                url: u.getUrl('addAgRep', {
                                    ulogin: data.user_login
                                }),
                                content: iget2('p-manage-clients', 'zaregistrirovat-novogo-predstavitelya', 'Зарегистрировать нового представителя')
                            }
                        },
                        !hasLoginRights('is_agency_chief_lim_rep') && {
                            block: 'p-manage-clients',
                            elem: 'link',
                            content: {
                                block: 'link',
                                url: u.getUrl('showAgReps', {
                                    ulogin: data.user_login
                                }),
                                content: iget2('p-manage-clients', 'spisok-predstaviteley-agentstva', 'Список представителей агентства')
                            }
                        }
                    ],
                    center: {
                        block: 'b-page-title',
                        mix: [{
                            block: 'p-manage-clients',
                            elem: 'title'
                        }],
                        title: iget2('p-manage-clients', 'naznachenie-klientov-predstavitelyam-agentstva', 'Назначение клиентов представителям агентства')
                    },
                    rgap: true,
                    right: true
                },
                {
                    elem: 'row',
                    left: true,
                    center: firstRep ? [
                        {
                            block: 'b-layout-table',
                            content: [
                                {
                                    elem: 'row',
                                    content: [
                                        {
                                            elem: 'cell',
                                            mix: [{
                                                block: 'p-manage-clients',
                                                elem: 'section-title'
                                            }],
                                            content: iget2('p-manage-clients', 'predstaviteli', 'Представители') + ':'
                                        },
                                        {
                                            elem: 'cell',
                                            mix: [{
                                                block: 'p-manage-clients',
                                                elem: 'control'
                                            }],
                                            content: {
                                                block: 'p-manage-clients',
                                                elem: 'representatives-section',
                                                content: [
                                                    {
                                                        block: 'p-manage-clients',
                                                        elem: 'representatives',
                                                        representatives: reps
                                                    },
                                                    {
                                                        block: 'p-manage-clients',
                                                        elem: 'brief-wrap',
                                                        content: {
                                                            elem: 'brief',
                                                            representative: {
                                                                email: currentRep.email,
                                                                phone: currentRep.phone && currentRep.phone.toString(),
                                                                clientsNum: currentRep.clients_cnt,
                                                                campsNum: currentRep.camps_cnt
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        }
                                    ]
                                },
                                {
                                    elem: 'row',
                                    content: [
                                        {
                                            elem: 'cell',
                                            mix: [{
                                                block: 'p-manage-clients',
                                                elem: 'section-title'
                                            }],
                                            content: iget2('p-manage-clients', 'klienty', 'Клиенты') + ':'
                                        },
                                        {
                                            elem: 'cell',
                                            mix: [{
                                                block: 'p-manage-clients',
                                                elem: 'control'
                                            }],
                                            content: [
                                                {
                                                    block: 'p-manage-clients',
                                                    mix: {
                                                        block: 'b-search-on-list',
                                                        mods: {
                                                            type: 'offline'
                                                        }
                                                    },
                                                    elem: 'search'
                                                },
                                                {
                                                    block: 'p-manage-clients',
                                                    elem: 'clients-filter'
                                                }
                                            ]

                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            block: 'p-manage-clients',
                            elem: 'clients',
                            clients: data.clients.map(function(client) {
                                client.FIO = client.FIO && client.FIO.toString();

                                return client;
                            }),
                            sortBy: form.sort || 'login',
                            repsHash: repsHash,
                            searchStr: form.search_substring,
                            startIndex: Math.max(+form.page_num || 0, 0) * this.clientsPerPageQuantity
                        },
                        {
                            block: 'p-manage-clients',
                            elem: 'save-panel',
                            content: {
                                block: 'button',
                                mods: {
                                    disabled: 'yes'
                                },
                                mix: [{
                                    block: 'p-manage-clients',
                                    elem: 'save'
                                }],
                                content: iget2('p-manage-clients', 'sohranit', 'Сохранить')
                            }
                        },
                        !this.allFilteredClientsShownOnPage ?
                            {
                                block: 'p-manage-clients',
                                elem: 'pagination',
                                content: {
                                    block: 'button',
                                    mods: {
                                        disabled: 'yes'
                                    },
                                    mix: [{
                                        block: 'p-manage-clients',
                                        elem: 'save'
                                    }],
                                    content: iget2('p-manage-clients', 'sohranit', 'Сохранить')
                                }
                            } :
                                '',
                        {
                            block: 'p-manage-clients',
                            elem: 'no-data',
                            content: iget2('p-manage-clients', 'net-klientov-udovletvoryayushchih-usloviyam', 'Нет клиентов, удовлетворяющих условиям поиска')
                        }
                    ] : iget2('p-manage-clients', 'u-agentstva-net-predstaviteley', 'У агентства нет представителей по работе с клиентами.'),
                    rgap: true,
                    right: true
                }
            ]
        };
    }),

    elem('representatives').content()(function() {
        return {
            block: 'select',
            mods: {
                layout: 'content'
            },
            mix: [{
                block: 'p-manage-clients',
                elem: 'representatives-select'
            }],
            content: [
                {
                    block: 'button'
                },
                {
                    elem: 'control',
                    content: this.ctx.representatives.map(function(rep) {
                        var attrs = {
                                value: rep.uid
                            },
                            repTypeToTypeName = {
                                chief: iget2('p-manage-clients', 'rep-type-chief', 'тимлидер'),
                                main: iget2('p-manage-clients', 'rep-type-main', 'менеджер')
                            },
                            repTypeName = repTypeToTypeName[rep.lim_rep_type];

                        this.data.FORM.selected_agency == rep.login && (attrs.selected = 'selected');

                        return {
                            elem: 'option',
                            attrs: attrs,
                            content: (rep.FIO ? rep.FIO : '') + ' (' + rep.login + ') ' + (repTypeName || '')
                        };
                    }, this)
                }
            ]
        };
    }),

    elem('clients-filter').content()(function() {
        var form = this.data.FORM;

        return [
            {
                block: 'checkbox',
                mix: [{
                    block: 'p-manage-clients',
                    elem: 'filter',
                    elemMods: {
                        type: 'free'
                    }
                }],
                mods: {
                    checked: form.show_unassigned == undefined || +form.show_unassigned ? 'yes' : ''
                },
                text: iget2('p-manage-clients', 'svobodnye-klienty', 'Свободные клиенты')
            },
            {
                block: 'checkbox',
                mix: [{
                    block: 'p-manage-clients',
                    elem: 'filter',
                    elemMods: {
                        type: 'self'
                    }
                }],
                mods: {
                    checked: form.show_selected == undefined || +form.show_selected ? 'yes' : ''
                },
                text: iget2('p-manage-clients', 'klienty-vybrannogo-predstavitelya', 'Клиенты выбранного представителя')
            },
            {
                block: 'checkbox',
                mix: [{
                    block: 'p-manage-clients',
                    elem: 'filter',
                    elemMods: {
                        type: 'other'
                    }
                }],
                mods: {
                    checked: form.show_other == undefined ?
                        this.allClientsShownOnPage ? '' : 'yes' :
                        +form.show_other ? 'yes' : ''
                },
                text: iget2('p-manage-clients', 'klienty-ostalnyh-predstaviteley', 'Клиенты остальных представителей')
            }
        ];
    }),

    elem('pagination').def()(function() {
        var data = this.data;

        return {
            block: 'b-pager',
            mix: [{
                block: 'p-manage-clients',
                elem: 'pager'
            }],
            currentPage: data.FORM.page_num && data.FORM.page_num > -1 ?
                data.FORM.page_num : 0,
            startFrom: 0,
            perpageCount: this.clientsPerPageQuantity,
            totalCount: data.num_subclients_filtered,
            pageUrl: u.formatUrl({
                host: data.script,
                query: u.getUrlParams(['page_num'])
            }),
            pageParam: 'page_num',
            keydownReaction: false,
            content: [
                {
                    elem: 'title',
                    content: iget2('p-manage-clients', 'stranicy', 'Страницы')
                },
                {
                    elem: 'button-prev',
                    content: iget2('p-manage-clients', 'predydushchaya', 'предыдущая')
                },
                {
                    elem: 'button-next',
                    content: iget2('p-manage-clients', 'sleduyushchaya', 'следующая')
                },
                {
                    elem: 'pages',
                    showFirst: true,
                    showLast: true
                }
            ]
        };
    }),

    elem('search').content()(function() {
        var form = this.data.FORM,
            resetUrlParams = {
                ulogin: form.ulogin,
                selected_agency: form.selected_agency
            };

        return [
            {
                block: 'b-search-on-list',
                elem: 'input',
                value: form.search_substring,
                hint: iget2('p-manage-clients', 'nayti-klienta', 'Найти клиента')
            },
            {
                block: 'b-search-on-list',
                elem: 'button'
            },
            form.search_substring ?
                {
                    block: 'b-search-on-list',
                    elem: 'reset-link',
                    url: u.getUrl(this.data.cmd, resetUrlParams)
                } :
                ''
        ];
    })
);
