BEM.DOM.decl('p-manage-clients', {

    onSetMod: {

        js: function() {
            u.graspSelf.call(this, {
                repsSelect: 'select on representatives-select',
                clients: 'b-data-table inside',
                saveButton: 'button on save'
            });

            this._reps = this.params.reps;
            this._clientsCheckboxes = this.findBlocksInside(this.clients.domElem, 'checkbox');
            this._currentRep = this._reps[this.repsSelect.val()];

            this.repsSelect.on('change', this._onChangeRep, this);

            BEM.blocks['checkbox']
                .on(this.elem('filter'), 'change', this._filterClients, this)
                .on(this.clients.domElem, 'change', function() {
                    this.saveButton.setMod('disabled', this._getChanges() ? '' : 'yes');
                }, this);

            this.clients.on('sorted', this._refreshClientsNumeration, this);
            this.saveButton.on('click', function() {
                this._onSaveAction();
            }, this);

            this._search = this.findBlockOn('search', 'b-search-on-list');
            this._search
                .on('offlineSearch', this._filterClientsWithReload, this);

            this._updateView();
        }
    },

    /**
     * Перезагружает страницу для фильтрации списока клиентов
     *
     * @param {Object} e
     * @param {Object} data данные поисковой формы
     * @param {String} data.search значение поисковой строки
     * @private
     */
    _filterClientsWithReload: function(e, data) {
        var filters = this._getFiltersState(),
            params = {
                selected_agency: this._currentRep.login,
                ulogin: u.consts('ulogin'),
                cmd: u.consts('cmd'),
                show_unassigned: +filters.free,
                show_selected: +filters.self,
                show_other: +filters.other,
                search_substring: this._search.getValue()
            };

        (data || {}).search && (params.search_substring = data.search);

        BEM.create({ block: 'i-request', mods: { type: 'form' } })
            .submit(params, { url: '/registered/main.pl', type: 'get' });
    },

    /**
     * Вызывает фильтрацию клиентов и проставление чекбоксов клиентов
     * @private
     */
    _updateView: function() {
        this
            ._filterClients()
            ._setClientsCheckboxes();
    },

    /**
     * Фильтрует список клиентов
     * @returns {BEM}
     * @private
     */
    _filterClients: function() {
        var uid = this._currentRep.uid,
            state = this._getFiltersState(),
            visibleRows;

        this
            .setMod(this.findElem('client-row'), 'hide', state.other ? 'no' : 'yes')
            .setMod(this.findElem('client-row', 'uid', 'none'), 'hide', state.free ? 'no' : 'yes')
            .setMod(this.findElem('client-row', 'uid', uid), 'hide', state.self ? 'no' : 'yes');

        visibleRows = this.findElem('client-row', 'hide', 'no');

        visibleRows.length && this._refreshClientsNumeration();

        this.toggleMod('no-data', 'yes', !visibleRows.length);

        this._updateFiltersAvailability();

        return this;
    },

    /**
     * Выставляет модификатор disabled для фильтра если он остался один выбранный,
     * иначе снимает disabled у всех, для того что бы пользователь не имел возможности снять все галки.
     * @private
     */
    _updateFiltersAvailability: function() {
        var filters = this.findBlocksInside(this.elem('clients-filter'), 'checkbox').filter(function(checkbox) {
                return checkbox.isChecked();
            }),
            disabled = filters.length == 1;

        filters.forEach(function(checkbox) {
            checkbox.toggleMod('disabled', 'yes', disabled);
        });
    },

    /**
     * Возвращает состояние фильтров
     * @returns {Object}
     * @private
     */
    _getFiltersState: function() {
        var filters = {};

        ['free', 'self', 'other'].forEach(function(type) {
            var checkbox = this[type + 'Filter'] ||
                (this[type + 'Filter'] = this.findBlockOn(this.elem('filter', 'type', type), 'checkbox'));

            filters[type] = checkbox.isChecked();
        }, this);

        return filters;
    },

    /**
     * Обработка запроса на сохранение (включая предупреждения)
     * params {Function} [callback]
     * @returns {BEM}
     */
    _onSaveAction: function(callback) {
        var changes = this._getChanges(),
            warningLogins = [];

        this.saveButton.setMod('disabled', 'yes');

        typeof callback === 'function' || (callback = function() {});

        if (!changes) {
            callback();

            return this;
        }

        // предупреждаем пользователя об изменении представителя у клиента
        changes.added.forEach(function(login) {
            !this.hasMod(this.findElem('client-checkbox', 'client', login), 'uid', 'none') &&
                warningLogins.push(login);
        }, this);

        if (warningLogins.length) {
            BEM.blocks['b-confirm'].open({
                type: 'confirm',
                message: (warningLogins.length === 1 ?
                    iget2('p-manage-clients', 'vy-tochno-hotite-izmenit', 'Вы точно хотите изменить представителя у клиента') :
                    iget2('p-manage-clients', 'vy-tochno-hotite-izmenit-101', 'Вы точно хотите изменить представителя у клиентов')) + ' ' + warningLogins.join(', ') + '?',

                onYes: function() {
                    this._save();
                    callback();
                }.bind(this),

                onNo: function() {
                    this._setClientsCheckboxes();
                    callback();
                }.bind(this)
            });
        } else {
            this._save();
            callback();
        }

        return this;
    },

    /**
     * Сохраняет список клиентов текущего представителя
     * @returns {BEM}
     * @private
     */
    _save: function() {
        var changes = this._getChanges(),

            // обновляет uid и ФИО представителя в списке клиентов
            updateRep = function(uid, action) {

                return function(login) {
                    var checkboxNode = this.findElem('client-checkbox', 'client', login),
                        checkbox = this.findBlockOn(checkboxNode, 'checkbox'),
                        uids = checkbox.params.uids,
                        rowNode = checkboxNode.closest(this.buildSelector('client-row')),
                        repCell = this.findElem(rowNode, 'client-cell', 'key', 'limited_agency'),
                        reps = this._reps;

                    if (uids === 'none') {
                        uids = [];
                    }

                    if (action == 'add') {
                        uids.push(uid);
                    } else if (action == 'remove') {
                        uids = uids.filter(function(u) { return u != uid; });
                    } else if (action == 'replace') {
                        uids = [uid];
                    }

                    checkbox.params.uids = uids.length === 0 ? 'none' : uids;

                    BEM.DOM.update(repCell, uids.length === 0 ? '–' : uids.map(function(uid) {
                        return reps[uid].fio;
                    }).join(', '));

                    this.delMod(rowNode, 'uid');
                    if (uids.length) {
                        uids.forEach(function(uid) {
                            rowNode.addClass(this.buildSelector('client-row', 'uid', uid).slice(1));
                        }.bind(this));
                    } else {
                        rowNode.addClass(this.buildSelector('client-row', 'uid', 'none').slice(1));
                    }
                };
            };

        this._saveRequest(changes);

        if (!this.params.canShareClient) {
            changes.added.forEach(updateRep(this._currentRep.uid, 'replace'), this);
        } else {
            changes.added.forEach(updateRep(this._currentRep.uid, 'add'), this);
        }

        changes.removed.forEach(updateRep(this._currentRep.uid, 'remove'), this);

        this
            ._updateCounts()
            ._setClientsCheckboxes()
            ._updateBrief();

        return this;
    },

    /**
     * Отправляет запрос на сохранение
     * @returns {BEM}
     * @private
     */
    _saveRequest: function(changes) {
        var url = u.getUrl('ajaxMoveClientToAgency', { agency_login: this._currentRep.login });

        changes.added.forEach(function(login) {
            url += '&add_cl_login=' + login;
        });

        changes.removed.forEach(function(login) {
            url += '&rm_cl_login=' + login;
        });

        BEM.create('i-request_type_ajax', {
            url: url,
            dataType: 'json',
            type: 'get'
        }).get({}, this._filterClients, { callbackCtx: this });

        return this;
    },

    /**
     * Обновление количества клиентов и кампаний
     * @returns {BEM}
     * @private
     */
    _updateCounts: function() {
        Object.keys(this._reps).forEach(function(uid) {
            var rep = this._reps[uid],
                _this = this;

            rep.clientsNum = rep.campsNum = 0;

            this.findElem('client-row', 'uid', uid).each(function() {
                rep.campsNum += +_this.elemParams(_this.elemify($(this), 'client-row')).campsNum;
                rep.clientsNum += 1;
            });
        }, this);

        return this;
    },

    /**
     * Обработчик события изменения редактируемого представителя
     * @param {Object} e
     * @private
     */
    _onChangeRep: function(e) {
        var uid = e.block.val(),
            rep = this._reps[uid],

            // обновление интерфейса под нового представителя
            update = function() {
                this._currentRep = rep;
                this.saveButton.setMod('disabled', 'yes');

                this
                    ._updateBrief()
                    ._filterClients()
                    ._setClientsCheckboxes();
            }.bind(this);

        if (this._getChanges()) {
            BEM.blocks['b-confirm'].open({
                type: 'confirm',
                message: iget2('p-manage-clients', 'sohranit-izmeneniya-spiska-klientov', 'Сохранить изменения списка клиентов представителя {foo}?', {
                    foo: this._currentRep.fio
                }),

                onYes: function() {
                    this._onSaveAction(update);
                }.bind(this),

                onNo: update
            });
        } else {
            update();
        }
    },

    /**
     * Отображает информацию о выбранном представителе
     * @returns {BEM}
     * @private
     */
    _updateBrief: function() {
        BEM.DOM.update(
            this.elem('brief-wrap'),
            BEMHTML.apply({ block: 'p-manage-clients', elem: 'brief', representative: this._currentRep }));

        return this;
    },

    /**
     * Восстанавливает нумерацию строк в таблице клиентов
     * @returns {BEM}
     * @private
     */
    _refreshClientsNumeration: function() {
        this.findElem('client-row', 'hide', 'no').each(function(n, row) {
            $(row.children[0]).text(n + 1);
        });

        return this;
    },

    /**
     * Установка чекбоксов в списке клиентов в исходное состояние для текущего представителя
     * @returns {BEM}
     * @private
     */
    _setClientsCheckboxes: function() {
        var uid = this._currentRep.uid;

        this._initialState = [];

        this._clientsCheckboxes.forEach(function(checkbox) {
            var isChecked = u._.contains(checkbox.params.uids, uid);

            checkbox.setMod('checked', isChecked ? 'yes' : '');
            isChecked && this._initialState.push(this.getMod(checkbox.domElem, 'client'));
        }, this);

        return this;
    },

    /**
     * Возвращает изменения, которые были сделаны в списке выбора клиентов
     * @returns {Object|null}
     */
    _getChanges: function() {
        var current = [],
            distinct = function(array) {
                return function(item) { return array.indexOf(item) === -1 };
            },
            result;

        this._clientsCheckboxes.forEach(function(checkbox) {
            checkbox.isChecked() && current.push(this.getMod(checkbox.domElem, 'client'));
        }, this);

        result = {
            added: current.filter(distinct(this._initialState)),
            removed: this._initialState.filter(distinct(current))
        };

        return (result.added.length || result.removed.length) ? result : null;
    }

});
