match(function() {
    return this.data.cmd === 'showFeeds';
})(

    block('app-main').mode('page-block')('p-manage-feeds'),

    block('app-main').mode('is-header-enabled')(function() {
        return this.data.FORM.popupMode !== '1';
    }),
    block('app-main').mode('is-footer-enabled')(function() {
        return this.data.FORM.popupMode !== '1';
    }),

    block('b-page').mode('title')(function() {
        return iget2('p-manage-feeds', 'upravlenie-fidami', 'Управление фидами');
    })
);

block('p-manage-feeds')(

    addJs()(function() {
        return {
            feedsTotalCount: this.data.client_feed_count,
            allowEditFeeds: this.data.allow_edit_feeds || hasLoginRights('limited_support_control'),
            disabledFeeds: hasLoginRights('super_control') ? [] : ['news'],
            feedsCountLimit: hasLoginRights('superreader_control') ? 0 : this.data.client_limits.feed_count_limit
        };
    }),

    content()(function() {
        var isPopupMode = this.data.FORM.popupMode === '1';

        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-80'
                },
                content: [
                    {
                        elem: 'row',
                        left: true,
                        right: [
                            {
                                block: 'b-page-title',
                                mix: {
                                    block: 'p-manage-feeds',
                                    elem: 'title'
                                },
                                content: {
                                    elem: 'title',
                                    content: [
                                        iget2('p-manage-feeds', 'upravlenie-fidami', 'Управление фидами'),
                                        {
                                            block: 'b-help-link',
                                            mods: {
                                                type: 'modal'
                                            },
                                            stretched: true,
                                            url: u.getHelpUrl('smart-banners-feed')
                                        }
                                    ]
                                }
                            },
                            {
                                block: 'p-manage-feeds',
                                elem: 'description'
                            },
                            {
                                block: 'p-manage-feeds',
                                elem: 'add-search-wrap',
                                content: [
                                    {
                                        block: 'button',
                                        mods: {
                                            size: 's',
                                            disabled: 'yes'
                                        },
                                        mix: {
                                            block: 'p-manage-feeds',
                                            elem: 'create-feed'
                                        },
                                        content: [
                                            {
                                                block: 'image',
                                                mix: [{
                                                    block: 'button',
                                                    elem: 'icon'
                                                }],
                                                mods: {
                                                    type: 'add'
                                                }
                                            },
                                            iget2('p-manage-feeds', 'dobavit-fid', 'Добавить фид')
                                        ]
                                    },
                                    {
                                        block: 'p-manage-feeds',
                                        elem: 'search'
                                    },
                                    {
                                        block: 'p-manage-feeds',
                                        elem: 'feed-count-limit',
                                        elemMods: {
                                            hidden: 'yes'
                                        },
                                        content: (function(count) {
                                            return u.pluralizeWord(
                                                [
                                                    iget2('p-manage-feeds', 'mozhet-byt-dobavleno-ne', 'Может быть добавлено не более {foo} фида', {
                                                        foo: count
                                                    }),
                                                    iget2('p-manage-feeds', 'mozhet-byt-dobavleno-ne-102', 'Может быть добавлено не более {foo} фидов', {
                                                        foo: count
                                                    }),
                                                    iget2('p-manage-feeds', 'mozhet-byt-dobavleno-ne-102', 'Может быть добавлено не более {foo} фидов', {
                                                        foo: count
                                                    })
                                                ],
                                                count);
                                        })(this.data.client_limits.feed_count_limit)
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                block: 'l-page',
                mods: isPopupMode ? undefined : {
                    layout: '84'
                },
                content: [
                    {
                        elem: 'row',
                        center: {
                            block: 'b-feeds-list',
                            allowEditFeeds: this.data.allow_edit_feeds || hasLoginRights('limited_support_control'),
                            isPopupMode: isPopupMode,
                            mix: {
                                block: 'p-manage-feeds',
                                elem: 'feeds-list'
                            }
                        }
                    }
                ]
            }
        ];
    }),

    elem('description').content()(function() {
        if (this.data.FORM.popupMode === '1') {
            return null;
        }

        return [
            {
                block: 'link',
                mix: {
                    block: 'p-manage-feeds',
                    elem: 'back-link'
                },
                url: u.getUrl('showCamps', withUidPar({})),
                content: iget2('p-manage-feeds', 'vernutsya-k-spisku-kampaniy', 'Вернуться к списку кампаний')
            }
        ];
    }),

    elem('search').content()(function() {
        return {
            block: 'input',
            mods: {
                size: 's',
                disabled: 'yes'
            },
            mix: {
                block: 'p-manage-feeds',
                elem: 'search-input'
            },
            placeholder: iget2('p-manage-feeds', 'nazvanie-fida-ili-id', 'Название фида или id'),
            content: [
                {
                    elem: 'control'
                }
            ]
        };
    })
);
