BEM.DOM.decl('p-manage-feeds', {

    onSetMod: {
        js: function() {
            this._DM = BEM.MODEL.create('dm-feed-list');

            u.graspSelf.call(this, {
                _feedsList: 'b-feeds-list on feeds-list',
                _createFeedButton: 'button on create-feed',
                _searchInput: 'input on search-input'
            });

            this._VM = this._feedsList.model;

            // общее количество фидов на странице (параметр выбирается в
            // процессе работы со списком как максимальный totalCount модели списка фидов)
            this._feedsTotalCount = this.params.feedsTotalCount;
            //у пользователя есть права на создание/редактирование фидов
            this._allowEditFeeds = this.params.allowEditFeeds;

            // лимит фидов, который может создать пользователь
            this._feedsCountLimit = this.params.feedsCountLimit;

            this.history = BEM.blocks.history.getInstance();
            this.location = BEM.blocks.location.getInstance();

            this.history.on('statechange', function(e, data) {
                this._restoreState((data.state || data).url);
            }, this);

            this._createFeedButton.on('click', function() {
                this._feedsList.openFeedEditPopup(this._createFeedButton, null, this.params.disabledFeeds);
            }, this);

            // при удалении элементов общее их число необходимо уменьшать
            this._DM.on('items', 'remove', function() {
                this ._feedsTotalCount--;
            }, this);

            this._VM
                .on('page rowsPerPage search sort reverse', 'change', this._changeState, this)
                .on('sync:from', function() {
                    var createButtonEnabled = this._isCreateButtonEnabled();

                    this._createFeedButton.toggleMod('disabled', 'yes', !createButtonEnabled);

                    this.toggleMod(this.elem('feed-count-limit'), 'hidden', 'yes', createButtonEnabled);
                }, this);

            this._feedsList
                .on('lockState', function(e, data) {
                    this._createFeedButton.toggleMod('disabled', 'yes', data.locked);
                }, this)
                .on('lockState render:before', function(e, data) {
                    this._searchInput.toggleMod('disabled', 'yes', e.type != 'lockState' || data.locked);
                }, this)
                .on('render:after', function() {
                    (this._VM.get('search') || this._VM.get('totalCount')) && this._searchInput.delMod('disabled');

                    this._searchInput.hasMod('focused', 'yes') &&
                        this._searchInput.delMod('focused').setMod('focused', 'yes');
                }, this);

            this._searchInput.on('change paste', $.debounce(function(e, data) {
                data && data.ignore || this._VM.set('search', this._searchInput.val());
            }, 777, this), this);

            this._restoreState();
        }
    },

    /**
     * Возвращает true, если кнопка добавления фида должна быть включена
     * @return {Boolean}
     * @private
     */
    _isCreateButtonEnabled: function() {
        if (!this._allowEditFeeds) return false;

        this._feedsTotalCount = Math.max(this._feedsTotalCount, this._VM.get('totalCount'));

        return this._feedsTotalCount < this._feedsCountLimit;
    },

    /**
     * Восстанавливает состояние блока списка фидов по текущему url
     * @param {String} [url]
     * @private
     */
    _restoreState: function(url) {
        var stateObj = u.parseUrl(url || this.location.getUri().toString()).query;

        // при обновлении модели из этого метода не нужно обновлять историю
        this._locked = true;

        this._VM
            .update({
                sort: stateObj.sort,
                reverse: stateObj.reverse,
                search: stateObj.search && decodeURIComponent(stateObj.search)
            })
            // страницу задаём последней, так как при сортировке и поиске автоматически переходим на первую страницу
            .set('page', stateObj.page);

        this._locked = false;

        this._searchInput.val(this._VM.get('search'), { ignore: true });
    },

    /**
     * Обновляет историю навигации
     * @private
     */
    _changeState: function() {
        if (this._locked) return;

        var url = this.location.getUri();

        ['page', 'sort', 'reverse', 'search'].forEach(function(field) {
            var value = this._VM.get(field);

            url.deleteParam(field);

            // включение в url только значимых параметров
            (field == 'page' && value > 1 || field != 'page' && value) &&
                url.addParam(field, value);
        }, this);

        this.history.pushState(undefined, document.title, url.toString());
    }

});
