match(function() {
    return this.data.cmd === 'manageSurveys';
})(

    block('app-main').mode('page-block')('p-manage-surveys'),

    block('b-page').mode('title')(function() {
        return iget2('p-manage-surveys', 'upravlenie-oprosami', 'Управление опросами');
    })
);

block('p-manage-surveys')(

    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '47-44'
            },
            content: [
                {
                    elem: 'row',
                    left: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-manage-surveys',
                                elem: 'title-left'
                            }],
                            title: iget2('p-manage-surveys', 'sozdanie-i-redaktirovanie-oprosa', 'Создание и редактирование опроса')
                        },
                        {
                            block: 'b-form-errors-header',
                            mods: {
                                visible: this.data.error ? 'yes' : ''
                            },
                            mix: [{
                                block: 'p-manage-surveys',
                                elem: 'form-error'
                            }],
                            commonErrors: u.escapeHTML(this.data.error)
                        },
                        {
                            block: 'b-edit-survey',
                            mods: {
                                for: this.data.FORM.type || 'surveymonkey',
                                edit: this.data.survey_id ? 'yes' : undefined
                            }
                        },
                        {
                            block: 'link',
                            attrs: {
                                target: '_blank'
                            },
                            url: 'https://wiki.yandex-team.ru/users/nadiano/newclientagency/guide',
                            content: iget2('p-manage-surveys', 'instrukciya-sohraneniya-oprosa-s', 'Инструкция сохранения опроса с SurveyMonkey')
                        }
                    ],
                    rgap: true,
                    right: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-manage-surveys',
                                elem: 'title-right'
                            }],
                            title: iget2('p-manage-surveys', 'sohranennye-oprosy', 'Сохраненные опросы')
                        },
                        {
                            block: 'p-manage-surveys',
                            elem: 'list-surveys'
                        }
                    ]
                }
            ]
        };
    })
);
