BEM.DOM.decl('p-manage-surveys', {

    /**
     * Форма опроса
     * {BEM}
     */
    _editSurvey: null,

    /**
     * Получает форму опроса
     * @returns {BEM}
     * @private
     */
    _getEditSurvey: function() {
        return this._editSurvey || (this._editSurvey = this.findBlockInside('b-edit-survey'));
    },

    /**
     * Заполняет поля опроса
     * @param {Object} data
     * @private
     */
    _onEditSurvey: function(data) {
        this._getEditSurvey()
            .setMod('edit', 'yes')
            .setFields(data);
    },

    /**
     * Удаляет ранее сохраненный опрос
     * @param {Object} data
     * @private
     */
    _onRemoveSurvey: function(data) {
        BEM.blocks['b-confirm'].open({
            message: iget2('p-manage-surveys', 'opros-budet-udalen-prodolzhit', 'Опрос будет удален! Продолжить?'),
            onYes: function() {
                BEM.create({ block: 'i-request', mods: { type: 'form' } }, { url: u.consts('SCRIPT') })
                    .submit($.extend({ cmd: 'manageSurveys', submit_form: '1' }, data));
            }
        });
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('edit remove', 'b-survey', function(e, data) {
            this[e.type === 'remove' ? '_onRemoveSurvey' : '_onEditSurvey'](data);
        });

    }

});
