block('p-manage-vcards').elem('campaigns-dropdown')(

    def()(function() {
        return applyNext({
            'ctx.infoTitle': iget2('p-manage-vcards', 'kampaniya', 'Кампания'),
            'ctx.campaignName': [
                '&laquo;' + u.escapeHTML(this.ctx.campaign.name) + '&raquo;',
                '&#8470;',
                this.ctx.campaign.cid
            ].join('&nbsp;')
        });
    }),

    content()(function() {
        return [
            this.ctx.infoTitle,
            {
                block: 'p-manage-vcards',
                elem: 'campaigns-dropdown-switcher',
                content: this.ctx.campaignName
            }
        ];
    }),

    match(function() {
        return this.ctx.campaigns.length;
    }).content()(function() {
        return [
            this.ctx.infoTitle,
            {
                block: 'dropdown',
                mix: [{
                    block: 'p-manage-vcards',
                    elem: 'campaigns-dropdown-switcher'
                }],
                content: [
                    {
                        block: 'link',
                        mods: {
                            pseudo: 'yes',
                            inner: 'yes'
                        },
                        mix: [{
                            block: 'dropdown',
                            elem: 'switcher'
                        }],
                        content: [
                            this.ctx.campaignName,
                            {
                                block: 'p-manage-vcards',
                                elem: 'dropdown-arrow'
                            }
                        ]
                    },
                    {
                        elem: 'popup',
                        js: {
                            directions: 'bottom-left'
                        },
                        elemMods: { adaptive: 'no' },
                        content: {
                            block: 'p-manage-vcards',
                            elem: 'campaigns',
                            ulogin: this.ctx.ulogin,
                            campaigns: this.ctx.campaigns
                        }
                    }
                ]
            }
        ];
    })
);
