block('p-manage-vcards').elem('campaigns').content()(function() {
    return this.ctx.campaigns.map(function(c) {
        var bannersCount = c.banners_cnt,
            withoutVCards = bannersCount - c.banners_with_phone_cnt;

        return {
            elem: 'campaign',
            content: [
                {
                    block: 'link',
                    url: u.getUrl('manageVCards', {
                        cid: c.cid,
                        ulogin: this.ctx.ulogin
                    }),
                    content: [u.escapeHTML(c.name), '&#8470;', c.cid].join('&nbsp;')
                },
                {
                    elem: 'note',
                    content: iget2('p-manage-vcards', 'obyavleniy-s-iz-nih', '(объявлений: {foo}, из них без визиток: {bar})', {
                        foo: bannersCount,
                        bar: withoutVCards
                    })
                }
            ]
        };
    }, this);
});
