match(function() {
    return this.data.cmd === 'manageVCards';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data,
                cid = data.FORM.cid,
                bannersCounts = {};

            // data.vcards = [];
            // data.banners = [];
            //
            // for (var bannersIndex = 0; bannersIndex <= 1; bannersIndex++) {
            //
            //     data.banners.push({
            //       "cid": "13230491",
            //       "vcard_id": 'v' + bannersIndex,
            //       "bid": '1350884271',
            //       "title": "«Вместе» ресторан в Петербурге",
            //       "body": "Фотографии, отзывы, карта и меню. Забронируйте столик бесплатно!",
            //       "display_href": "Рестораны-Вместе",
            //       "domain": "vmeste.tomesto.ru",
            //       "vcard": {
            //           "vcard_id": 'v' + bannersIndex,
            //       },
            //       "splited_phrases": [
            //         "ресторан !вместе -меню -отзыв -сайт -семейный -спб",
            //         "ресторан !вместе меню",
            //         "ресторан !вместе отзывы",
            //         "ресторан !вместе официальный сайт",
            //         "ресторан !вместе сайт -официальный",
            //         "ресторан !вместе спб",
            //         "семейный ресторан !вместе"
            //       ],
            //       "group_name": "\"Вместе\" ресторан в Петербурге",
            //       "hash_flags": {},
            //       "isArchived": true,
            //       "sitelinks": {
            //         "modelId": 'links' + bannersIndex,
            //         "title0": "На Ленинском",
            //         "href0": "https://tomesto.ru/spb/places/vmeste?utm_medium=cpc&utm_source=yandex&utm_campaign=spb_setevye-restorany_y_poisk&utm_term={keyword}--{position_type}{position}",
            //         "url_protocol0": "https",
            //         "title1": "На Комендантском",
            //         "href1": "https://tomesto.ru/spb/places/vmeste-komendantskiy?utm_medium=cpc&utm_source=yandex&utm_campaign=spb_setevye-restorany_y_poisk&utm_term={keyword}--{position_type}{position}",
            //         "url_protocol1": "https"
            //       },
            //       "modelId": bannersIndex + 'id',
            //       "isVCardEmpty": false,
            //       "is_vcard_open": true,
            //       "has_vcard": 1,
            //       "image_model": {},
            //       "href_model": {
            //         "href": "https://vmeste.tomesto.ru/spb/groups/vmeste?utm_medium=cpc&utm_source=yandex&utm_campaign=spb_setevye-restorany_y_poisk&utm_term={keyword}--{position_type}{position}",
            //         "domain": "vmeste.tomesto.ru"
            //       },
            //       "has_site_enum": "yes"
            //     });
            //
            //
            //     for (var vcardIndex = 0; vcardIndex <= 1; vcardIndex++) {
            //         data.vcards.push({
            //             "cid": "13230491",
            //             "name": "Бар \"Родео\"",
            //             "country_code": "+7",
            //             "city_code": "495",
            //             "phone": "215-52-18",
            //             "ext": null,
            //             "country": "Россия",
            //             "city": "Москва",
            //             "metro_name": null,
            //             "metro": null,
            //             "street": "Большая Полянка ул.",
            //             "house": "54",
            //             "build": null,
            //             "apart": null,
            //             "worktimes": [
            //               {
            //                 "m2": "00",
            //                 "d1": "пн",
            //                 "h2": "06",
            //                 "d2": "вс",
            //                 "h1": "18",
            //                 "m1": "00"
            //               }
            //             ],
            //             "contactperson": null,
            //             "contact_email": null,
            //             "im_client": null,
            //             "im_login": null,
            //             "vcard_id": 'v' + vcardIndex,
            //             "extra_message": null,
            //             "bannersCount": {
            //               "total": 1,
            //               "active": 0
            //             },
            //             "isArchived": false,
            //             "position": 1,
            //             "color": 8
            //         })
            //     }
            // }

            // поиск текущей выбранной кампании с исключением её из общего списка
            data.campaigns = data.camps_name_only.filter(function(campaign) {
                if (campaign.cid != cid) return true;

                data.campaign = campaign;

                return false;
            });

            // сбор нужных только для этой страницы полей каждого баннера из списка баннеров
            data.banners = data.camp.banners.map(function(banner) {
                var vcardId = banner.vcard_id,
                    bannersCount;

                banner.splited_phrases = banner.phrases.map(function(phrase) {
                    return phrase.phrase;
                });
                banner.isArchived = banner.statusArch === 'Yes';
                banner.status_click_track = data.campaign.status_click_track;

                if (vcardId) {
                    // для модели передаётся только id визитки
                    // работа с визиткой должна быть через её модель
                    banner.vcard = {
                        vcard_id: vcardId
                    };

                    bannersCount = bannersCounts[vcardId] || (bannersCounts[vcardId] = {
                        total: 0,
                        active: 0
                    });

                    bannersCount .total++;

                    banner.isArchived || bannersCount .active++;
                }

                (banner.phrases || []).forEach(function(phrase) {
                    phrase.key_words = u.phraseFormatter.getKeyWords(phrase.phrase);
                });

                return banner;
            });

            // сбор нужных только для этой страницы полей каждой визитки из списка визиток
            // с отметкой есть ли у текущей кампании визитки + сортировка визиток с присваиванием позиции
            data.vcards = data.vcards
                .map(function(vcard) {
                    var bannersCount = bannersCounts[vcard.vcard_id] || {
                        total: 0,
                        active: 0
                    };

                    if (data.campaign && !data.campaign.hasOwnVCards && vcard.cid === data.campaign.cid) {
                        data.campaign.hasOwnVCards = true;
                    }

                    return {
                        cid: vcard.cid,
                        name: vcard.name,
                        country_code: vcard.country_code,
                        city_code: vcard.city_code,
                        phone: vcard.phone,
                        ext: vcard.ext,
                        country: vcard.country,
                        city: vcard.city,
                        metro_name: vcard.metro_name,
                        metro: vcard.metro,
                        street: vcard.street,
                        house: vcard.house,
                        build: vcard.build,
                        apart: vcard.apart,
                        worktimes: vcard.worktimes,
                        contactperson: vcard.contactperson,
                        contact_email: vcard.contact_email,
                        im_client: vcard.im_client,
                        im_login: vcard.im_login,
                        vcard_id: vcard.vcard_id,
                        extra_message: vcard.extra_message,
                        bannersCount: bannersCount,
                        isArchived: !(bannersCount.total === 0 || bannersCount.active > 0)
                    };
                })
                .sort(function(vcard1, vcard2) {
                    // выталкиваем в конец списка в приоритетном порядке:
                    return (vcard1.cid != cid - vcard2.cid != cid) || // - визитки не из этой кампании
                        (vcard1.isArchived - vcard2.isArchived) || // - визитки, которые привязаны только к архивным баннерам
                        (vcard1.vcard_id - vcard2.vcard_id); // - визитки, имеющие больший идентификатор
                })
                .map(function(vcard, index) {
                    vcard.position = index + 1;
                    vcard.color = vcard.position % 12 || 1;

                    return vcard;
                }).reduce(function(res, vcard, inedx) {
                    if (inedx < 3000) {
                        res.push(vcard);
                    }

                    return res;
                }, []);

            delete data.camp;

            return data;
        }),

        mode('page-block')('p-manage-vcards')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-manage-vcards', 'master-zapolneniya-virtualnyh-vizitok', 'Мастер заполнения виртуальных визиток');
    })
);

block('p-manage-vcards')(

    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-50-30'
            },
            content: [
                {
                    elem: 'row',
                    left: '&nbsp;',
                    center: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-manage-vcards',
                                elem: 'page-title'
                            }],
                            content: {
                                elem: 'title',
                                content: iget2('p-manage-vcards', 'master-zapolneniya-virtualnyh-vizitok', 'Мастер заполнения виртуальных визиток')
                            }
                        },
                        {
                            block: 'p-manage-vcards',
                            elem: 'info',
                            ulogin: this.data.user_login,
                            campaign: this.data.campaign,
                            campaigns: this.data.campaigns
                        }
                    ],
                    right: '&nbsp;'
                },
                {
                    elem: 'row',
                    left: {
                        block: 'b-manage-vcards',
                        consts: this.data.CONSTS,
                        campaign: this.data.campaign,
                        vcards: this.data.vcards,
                        banners: this.data.banners,
                        ulogin: this.data.user_login
                    },
                    ctxCells: {
                        left: {
                            attrs: {
                                colspan: 3
                            }
                        }
                    }
                }
            ]
        };
    })
);
