block('p-manager-my-clients').elem('aux-actions')(

    replace()(function() {
        return {
            block: 'b-layout-table',
            mix: [{
                block: 'p-manager-my-clients',
                elem: 'aux-actions'
            }],
            content: {
                elem: 'row',
                content: {
                    elem: 'cell',
                    content: {
                        block: 'b-additional-actions',
                        groups: apply('groups')
                    }
                }
            }
        };
    }),

    mode('groups')(function() {
        var data = this.data,
            rights = data.login_rights,
            pageParams = this.pageParams,
            showTeamleadAux = pageParams.showTeamleadAux,
            isMy = u.consts('isMy'),
            isTeamleader = hasLoginRights('is_any_teamleader'),
            isMedia = hasLoginRights('media_control'),
            isSuperMediaPlanner = hasLoginRights('is_super_media_planner'),
            uidUrl = data.uid_url,
            uidParam = {},
            groups = [],
            groupsIdx = {},
            groupsNames = {
                stat: iget2('p-manager-my-clients', 'statistika', 'Статистика'),
                management: iget2('p-manager-my-clients', 'upravlenie-kampaniyami', 'Управление кампаниями'),
                reports: iget2('p-manager-my-clients', 'otchety-po-kampaniyam', 'Отчеты по кампаниям'),
                additional: iget2('p-manager-my-clients', 'dopolnitelnye-vozmozhnosti', 'Дополнительные возможности'),
                'client-management': iget2('p-manager-my-clients', 'upravlenie-klientami', 'Управление клиентами'),
                empty: ''
            },
            getOrCreateGroupObject = function(index) {
                var groupObj = groupsIdx[index] !== undefined ? groups[groupsIdx[index]] : {};

                if (groupsIdx[index] === undefined) {
                    groupObj.title = groupsNames[index];
                    groupObj.links = [];
                    groups.push(groupObj);
                    groupsIdx[index] = groups.length - 1;
                }

                return groupObj;
            },
            addLink = function(groupName, linkObj) {
                var groupObj = getOrCreateGroupObject(groupName);

                groupObj.links.push(linkObj);
            },
            addLinks = function(groupName, links) {
                if (links !== undefined) {
                    var groupObj = getOrCreateGroupObject(groupName);
                    groupName == 'reports' && getOrCreateGroupObject('empty');

                    groupObj.links = groupObj.links.concat(links);
                }
            },
            reportUrl = function(type) {
                return u.getUrl('getReport', {
                    type: type,
                    ulogin: uidUrl.value
                });
            };

        uidUrl && (uidParam[uidUrl.key] = uidUrl.value) || (uidParam = '');

        addLinks('reports', isMedia ?
            (isSuperMediaPlanner ?
                [{
                    block: 'link',
                    url: reportUrl(5),
                    content: iget2('p-manager-my-clients', 'rabotayushchim-bez-klikov', 'Работающим без кликов')
                }] :
                undefined) :
            [
                {
                    block: 'link',
                    url: reportUrl(1),
                    content: iget2('p-manager-my-clients', 'novym-ozhidayushchim-prihoda-deneg', 'Новым, ожидающим прихода денег')
                },
                {
                    block: 'link',
                    url: reportUrl(2),
                    content: iget2('p-manager-my-clients', 'rabotavshim-ozhidayushchim-prihoda-deneg', 'Работавшим, ожидающим прихода денег'),
                    elemMods: {
                        margined: 'yes'
                    }
                },
                {
                    block: 'link',
                    url: reportUrl(3),
                    content: iget2('p-manager-my-clients', 'zakanchivayushchimsya', 'Заканчивающимся')
                },
                {
                    block: 'link',
                    url: reportUrl(4),
                    content: iget2('p-manager-my-clients', 'zakonchivshimsya-na-kotorye-ne', 'Закончившимся, на которые не выписан счёт'),
                    elemMods: {
                        margined: 'yes'
                    }
                },
                {
                    block: 'link',
                    url: reportUrl(5),
                    content: iget2('p-manager-my-clients', 'rabotayushchim-bez-klikov', 'Работающим без кликов')
                },
                {
                    block: 'link',
                    url: reportUrl(6),
                    content: iget2('p-manager-my-clients', 'ostanovlennym-na-kotoryh-est', 'Остановленным, на которых есть деньги')
                }
            ]
        );

        pageParams.clientsCount && addLink('stat', {
            block: 'link',
            url: u.getUrl('showCampStat', this.extend({
                stat_type: 'by_clients'
            }, uidParam)),
            content: iget2('p-manager-my-clients', 'statistika-po-vsem-klientam', 'Статистика по всем клиентам')
        });

        (pageParams.agencyCount || isTeamleader) && addLink('stat', {
            block: 'link',
            url: u.getUrl('showCampStat', this.extend({
                stat_type: 'by_agencies'
            }, uidParam)),
            content: iget2('p-manager-my-clients', 'statistika-po-vsem-agentstvam', 'Статистика по всем агентствам')
        });

        isTeamleader && isMy && addLink('stat', {
            block: 'link',
            url: u.getUrl('showCampStat', {
                stat_type: 'by_managers'
            }),
            content: iget2('p-manager-my-clients', 'statistika-po-vsem-menedzheram', 'Статистика по всем менеджерам')
        });

        isTeamleader && addLink('management', {
            block: 'link',
            url: u.formatUrl({
                host: 'https://direct.' + data.yandex_domain,
                path: '/commander/'
            }),
            content: iget2('p-manager-my-clients', 'kommander', 'Коммандер')
        });

        isTeamleader && hasLoginRights('super_control', 'support_control', 'superreader_control') &&
            addLink('management', {
                block: 'link',
                url: u.getUrl('apiSettings', data.FORM.ulogin ? { ulogin: u.escapeHTML(data.FORM.ulogin) } : null),
                content: iget2('p-manager-my-clients', 'api', 'API')
            });

        if (isMy) {
            addLink('client-management', {
                block: 'link',
                url: u.getUrl('showOfferToServicing'),
                content: iget2('p-manager-my-clients', 'kampanii-dlya-priema-na', 'Кампании для приема на обслуживание')
            });

            addLink('client-management', {
                block: 'link',
                url: u.getUrl('admShowAddAgency'),
                content: iget2('p-manager-my-clients', 'dobavit-agentstvo', 'Добавить агентство')
            });

            addLink('management', {
                block: 'link',
                url: u.getUrl('copyCamp'),
                content: iget2('p-manager-my-clients', 'skopirovat-kampaniyu', 'Скопировать кампанию')
            });
        }

        rights.ChangeManagerSys && showTeamleadAux &&
            addLink('client-management', {
                block: 'link',
                url: u.getUrl('changeManager'),
                content: iget2('p-manager-my-clients', 'smenit-menedzhera-na-kampanii', 'Сменить менеджера на кампании')
            });

        rights.ChangeManagerSys && showTeamleadAux &&
            addLink('client-management', {
                block: 'link',
                url: u.getUrl('changeManagerOfClient'),
                content: iget2('p-manager-my-clients', 'smenit-menedzhera-u-klienta', 'Сменить менеджера у клиента')
            });

        rights.ChangeManagerOfAgencySys && showTeamleadAux && addLink('client-management', {
            block: 'link',
            url: u.getUrl('changeManagerOfAgency'),
            content: iget2('p-manager-my-clients', 'smenit-menedzhera-u-agentstva', 'Сменить менеджера у агентства')
        });

        rights.UnServicingCamp && showTeamleadAux && addLink('client-management', {
            block: 'link',
            url: u.getUrl('unServicingCamp'),
            content: iget2('p-manager-my-clients', 'snyat-kampaniyu-s-obsluzhivaniya', 'Снять кампанию с обслуживания менеджером')
        });

        !isTeamleader && hasLoginRights('super_control', 'support_control', 'superreader_control') &&
            addLink('management', {
                block: 'link',
                url: u.getUrl('apiSettings', data.FORM.ulogin ? { ulogin: u.escapeHTML(data.FORM.ulogin) } : null),
                content: iget2('p-manager-my-clients', 'api', 'API')
            });

        !isTeamleader && addLink('management', {
            block: 'link',
            url: u.formatUrl({
                host: 'https://direct.' + data.yandex_domain,
                path: '/commander/'
            }),
            content: iget2('p-manager-my-clients', 'kommander', 'Коммандер')
        });

        addLink('stat', {
            block: 'link',
            url: u.getUrl('listWarnPlace', this.extend({
                sort: 'addtime',
                reverse: 1,
                ws_place: 0,
                ws_time: '1d',
                ws_cid: 0,
                ws_done: 0
            }, uidParam)),
            content: iget2('p-manager-my-clients', 'traffic-volume-changes-monitoring', 'Мониторинг изменений объёма трафика по фразам')
        });

        return groups;
    })
);
