block('p-manager-my-clients').elem('tabs').replace()(function() {
    var data = this.data,
        rights = data.login_rights,
        links = [],
        noEmpty = function(list) {
            return list && list.length;
        };

    links.push({
        block: 'link',
        mods: {
            type: 'action'
        },
        url: data.FORM.ulogin ?
            u.getUrl('clientDescriptions', {
                ulogin: data.FORM.ulogin
            }) : u.getUrl('clientDescriptions'),
        content: iget2('p-manager-my-clients', 'pokazat-vse-primechaniya', 'Показать все примечания')
    });

    rights.manager_control && links.push({
        block: 'link',
        mods: {
            type: 'action'
        },
        url: u.getUrl('modifyUser', {
            rcmd: 'showManagerMyClients'
        }),
        content: iget2('p-manager-my-clients', 'nastroyki-menedzhera', 'Настройки менеджера')
    });

    return {
        block: 'b-list-tabs',
        mods: {
            theme: 'border-bottom'
        },
        tabs: {
            keys: ['active', 'potential', 'arch'],
            countItems: {
                active: noEmpty(data.managers_list) || noEmpty(data.dc_list) || noEmpty(data.ag_list),
                potential: data.potential_users_exists,
                arch: data.arch_users_exists
            },
            content: {
                potential: iget2('p-manager-my-clients', 'potencialnye', 'Потенциальные')
            }
        },
        links: links
    };
});
