match(function() {
    return this.data.cmd === 'showManagerMyClients';
})(

    block('app-main').mode('page-block')('p-manager-my-clients'),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            var data = this.data,
                title,
                agency = data.ag_list || [],
                clients = data.dc_list || [],
                clientsCount = clients.length,
                agencyCount = agency.length,
                isManagersOnly = !agencyCount && !clientsCount,
                isMy = u.consts('isMy'),
                showAux = !isManagersOnly || !hasLoginRights('media_control');

            title = isManagersOnly ?
                iget2('p-manager-my-clients', 'moi-menedzhery', 'Мои менеджеры') :
                isMy ?
                    iget2('p-manager-my-clients', 'moi-klienty', 'Мои клиенты') :
                    iget2('p-manager-my-clients', 'klienty-menedzhera', 'Клиенты менеджера');

            return applyNext({
                pageParams: {
                    title: title,
                    clientsCount: clientsCount,
                    agencyCount: agencyCount,
                    showAux: showAux,
                    showTeamleadAux: showAux && hasLoginRights('is_teamleader') && isMy,
                    isAgencyViewOwnRep: hasLoginRights('agency_control') && !isMy,
                    readonly: hasLoginRights('superreader_control', 'media_control'),
                    isManagersOnly: isManagersOnly
                }
            });
        }),

        mode('title')(function() {
            return this.pageParams.title;
        })
    )
);

block('p-manager-my-clients').content()(function() {
    var data = this.data,
        pageParams = this.pageParams,
        clientsCount = pageParams.clientsCount,
        agencyCount = pageParams.agencyCount,
        tables = [],
        needSearch = !!(!pageParams.isManagersOnly && (clientsCount + agencyCount) > 1);

    clientsCount && tables.push({
        caption: iget2('p-manager-my-clients', 'klienty-103', 'Клиенты:'),
        type: 'manager-clients'
    });

    agencyCount && tables.push({
        caption: iget2('p-manager-my-clients', 'agentstva', 'Агентства:'),
        type: 'manager-agents'
    });

    data.managers_list && u.consts('isMy') && data.FORM.tab != 'arch' && data.FORM.tab != 'potential' && tables.push({
        caption: hasLoginRights('is_superteamleader') ? iget2('p-manager-my-clients', 'timlidery', 'Тимлидеры:') : iget2('p-manager-my-clients', 'menedzhery', 'Менеджеры:'),
        type: 'manager-teamleader'
    });

    tables = tables.map(function(table) {
        return [
            {
                block: 'p-manager-my-clients',
                elem: 'caption',
                content: table.caption
            },
            {
                block: 'b-showclients-list',
                mods: {
                    type: table.type
                }
            }
        ];
    });

    return [
        {
            block: 'l-page',
            mods: {
                layout: '16-50-30'
            },
            content: {
                elem: 'row',
                left: true,
                center: {
                    block: 'p-manager-my-clients',
                    elem: 'header'
                },
                ctxCells: {
                    center: {
                        attrs: { colspan: '2' }
                    },
                    left: {
                        elemMods: { auto: 'yes' }
                    }
                }
            }
        },
        {
            block: 'l-page',
            mods: {
                layout: '84'
            },
            content: [
                {
                    elem: 'row',
                    center: [{
                        block: 'p-manager-my-clients',
                        elem: 'tabs'
                    }]
                },
                {
                    elem: 'row',
                    mix: [
                        needSearch ?
                            {
                                block: 'b-search-on-list',
                                mods: {
                                    type: 'online'
                                }
                            } :
                            '',
                        {
                            block: 'b-report-links',
                            js: {
                                isMedia: hasLoginRights('media_control'),
                                isSuperMediaPlanner: hasLoginRights('is_super_media_planner')
                            }
                        }
                    ],
                    center: [
                        needSearch && {
                            block: 'b-search-on-list',
                            elem: 'input',
                            hint: clientsCount && agencyCount ?
                                    iget2('p-manager-my-clients', 'nayti-klientov-i-agentstva', 'Найти клиентов и агентства') : iget2('p-manager-my-clients', 'nayti-agentstva', 'Найти агентства')
                        },
                        tables.length ?
                            tables :
                            {
                                block: 'p-manager-my-clients',
                                elem: 'empty-clients-list',
                                content: iget2('p-manager-my-clients', 'spisok-klientov-pust', 'Список клиентов пуст')
                            },
                        this.pageParams.showAux && {
                            block: 'p-manager-my-clients',
                            elem: 'aux-actions'
                        }
                    ]
                }
            ]
        }
    ];
});
