match(function() {
    return this.data.cmd === 'massBlockUsers';
})(

    block('app-main').mode('page-block')('p-mass-block-users'),

    block('b-page').mode('title')(function() {
        return iget2('p-mass-block-users', 'optovaya-blokirovka-spam-loginov', 'Оптовая блокировка спам-логинов');
    })
);

block('p-mass-block-users')(

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: {
                        block: 'b-page-title',
                        content: {
                            elem: 'title',
                            content: iget2('p-mass-block-users', 'optovaya-blokirovka-spam-loginov', 'Оптовая блокировка спам-логинов')
                        }
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: [
                        {
                            block: 'tabs-menu',
                            mods: {
                                size: 'm',
                                theme: 'border-bottom',
                                layout: 'horiz'
                            },
                            content: [
                                {
                                    elem: 'tab',
                                    elemMods: {
                                        active: 'yes'
                                    },
                                    content: {
                                        block: 'link',
                                        mix: [{
                                            block: 'p-mass-block-users',
                                            elem: 'tab-link'
                                        }],
                                        url: u.getUrl('massBlockUsers'),
                                        content: iget2('p-mass-block-users', 'blokirovka-loginov', 'Блокировка логинов')
                                    }
                                },
                                {
                                    elem: 'tab',
                                    content: {
                                        block: 'link',
                                        mix: [{
                                            block: 'p-mass-block-users',
                                            elem: 'tab-link'
                                        }],
                                        url: u.getUrl('findUsersByDomain'),
                                        content: iget2('p-mass-block-users', 'poisk-loginov-po-domenam', 'Поиск логинов по доменам')
                                    }
                                }
                            ]
                        },
                        {
                            block: 'p-mass-block-users',
                            elem: 'form'
                        },
                        !!this.data.users && {
                            block: 'p-mass-block-users',
                            elem: 'users'
                        }
                    ]
                }
            ]
        };
    }),

    elem('form').content()(function() {
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'p-mass-block-users',
                elem: 'form'
            }],
            action: this.data.script,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'massBlockUsers'
                }
            ],
            rows: [
                {
                    block: 'input',
                    mods: {
                        type: 'textarea'
                    },
                    name: 'login_list',
                    placeholder: iget2('p-mass-block-users', 'vvedite-loginy-v-stolbik', 'Введите логины в столбик или в строчку через запятую'),
                    content: [
                        {
                            elem: 'label',
                            content: iget2('p-mass-block-users', 'zablokirovat-loginy-po-spisku', 'Заблокировать логины по списку')
                        },
                        {
                            elem: 'control',
                            attrs: {
                                rows: '8'
                            }
                        }
                    ]
                },
                {
                    block: 'button',
                    mix: {
                        block: 'p-mass-block-users',
                        elem: 'submit'
                    },
                    type: 'submit',
                    content: iget2('p-mass-block-users', 'zablokirovat-loginy', 'Заблокировать логины')
                }
            ]
        };
    }),

    elem('users').content()(function() {
        var nonBlockedLoginsList = [],
            ulogins = [];

        this.data.users.forEach(function(user) {
            ulogins.push(user.ulogin);
            if (user.action === 'serviced' || user.action === 'admin') {
                nonBlockedLoginsList.push(user.ulogin);
            }
        });

        return (typeof this.data.FORM.login_list !== 'undefined') && [
            (ulogins.length && ulogins.length > nonBlockedLoginsList.length) ?
                {
                    block: 'p-mass-block-users',
                    elem: 'xls-link',
                    content: [
                        'bids-from-logins.csv',
                        ' ',
                        {
                            block: 'link',
                            url: u.getUrl('massBlockUsers', {
                                login_list: ulogins.join(';'),
                                bids_csv: 1
                            }),
                            content: iget2('p-mass-block-users', 'skachat', 'скачать')
                        }
                    ]
                } :
                iget2('p-mass-block-users', 'ne-naydeno-ni-odnogo', 'Не найдено ни одного объекта'),
            nonBlockedLoginsList.length ?
                {
                    block: 'p-mass-block-users',
                    elem: 'non-blocked-users-list',
                    content: iget2(
                        'p-mass-block-users',
                        'sleduyushchie-loginy-ne-byli',
                        'Следующие логины не были заблокированы: {logins}. Обратитесь к менеджеру.',
                        {
                            logins: u.spacer(nonBlockedLoginsList.map(function(login) {
                                return {
                                    block: 'p-mass-block-users',
                                    elem: 'user',
                                    content: login
                                };
                            }), ', ')
                        }
                    )
                } :
                ulogins.length ?
                    {
                        block: 'p-mass-block-user',
                        elem: 'success',
                        content: iget2('p-mass-block-users', 'loginy-uspeshno-zablokirovany', 'Логины успешно заблокированы')
                    } :
                    ''
        ];

    })
);
