match(function() {
    return this.data.cmd === 'modifyUser';
})(

    block('app-main').mode('page-block')('p-modify-user'),

    block('b-page').mode('title')(function() {
        return ((this.data.user_is_any_client && iget2('p-modify-user', 'klient', 'Клиент')) ||
            (this.data.user_role == 'agency' && iget2('p-modify-user', 'predstavitel-agentstva', 'Представитель агентства')) ||
                (this.data.is_developer && iget2('p-modify-user', 'razrabotchik', 'Разработчик')) ||
                    (this.data.is_super_manager != '0' && iget2('p-modify-user', 'super-menedzher', 'Супер-менеджер')) ||
                        u.ucfirst(u.getRoleName(this.data.user_role))) + ' ' + u.escapeHTML(this.data.login);
    })
);

block('p-modify-user').content()(function() {
    return {
        block: 'l-page',
        mods: {
            layout: '16-60-16'
        },
        content: {
            elem: 'row',
            left: true,
            right: true,
            rgap: true,
            center: {
                block: 'b-modify-user',
                js: {
                    name: 'b-modify-user',
                    permission: {
                        regionEdit: hasLoginRights('super_control', 'is_developer', 'manager_control'),
                        limitsEdit: this.data.login_rights.super_control || this.data.login_rights.is_developer ||
                            this.data.login_rights.support_control,
                        descEdit: this.data.allow_edit_description && !this.data.login_rights.agency_control,
                        limitsRead: ['super_control', 'is_developer', 'support_control']
                            .some(function(right) {
                                return !!this.data.login_rights[right];
                            }, this)
                    },
                    methodLimits: this.data.method_limits,
                    createTime: this.data.createtime_text,
                    login: escapeJs(this.data.login)
                },
                title: ((this.data.user_is_any_client && iget2('p-modify-user', 'klient', 'Клиент')) ||
                    (this.data.user_role == 'agency' && iget2('p-modify-user', 'predstavitel-agentstva', 'Представитель агентства')) ||
                        (this.data.is_developer && iget2('p-modify-user', 'razrabotchik', 'Разработчик')) ||
                            (this.data.is_super_manager != '0' && iget2('p-modify-user', 'super-menedzher', 'Супер-менеджер')) ||
                                (this.data.is_super_manager && iget2('p-modify-user', 'super-menedzher', 'Супер-менеджер')) ||
                                    u.ucfirst(u.getRoleName(this.data.user_role))) + ' ' + u.escapeHTML(this.data.login)
            }
        }
    };
});
