block('p-morda')(

    elem('navigation').content()(function() {
        var links = this.ctx.links || {};

        return [
            links.instruments && !!links.instruments.length && {
                elem: 'nav-section',
                title: iget2('p-morda', 'instrumenty', 'Инструменты'),
                links: links.instruments
            },
            links.help && !!links.help.length && {
                elem: 'nav-section',
                title: iget2('p-morda', 'pomoshch', 'Помощь'),
                links: links.help
            },
            links.partners && !!links.partners.length && {
                elem: 'nav-section',
                title: iget2('p-morda', 'sotrudnichestvo', 'Сотрудничество'),
                links: links.partners
            },
            {
                elem: 'support',
                support: this.ctx.support,
                domains: this.ctx.domains,
                feedback: this.ctx.feedback
            }
        ];
    }),

    elem('nav-section').content()(function() {
        return [
            {
                elem: 'nav-section-title',
                content: this.ctx.title
            },
            {
                elem: 'nav-section-links',
                tag: 'ul',
                content: this.ctx.links.map(function(link) {

                    return {
                        elem: 'nav-link',
                        tag: 'li',
                        content: {
                            block: 'link',
                            url: link.url,
                            content: link.title,
                            mix: link.mix
                        }
                    };
                })
            }
        ];
    })
);
