block('p-morda').content()(function() {

    var DEFAULT_VARIANT = 2, // фото мужчины с дрелью (см. DIRECT-73438)
        variant = this.ctx.variant || DEFAULT_VARIANT, // DIRECT-60696 Эксперимент с мордами Директа
        links = this.ctx.links,
        support = this.ctx.support,
        domains = this.ctx.domains,
        stories = this.ctx.stories,
        news = this.ctx.news,
        videoSrc = this.ctx.videoSrc,
        showStatistics = this.ctx.showStatistics,
        retargetingPixelLink = this.ctx.retargetingPixelLink,
        geoRegion = this.ctx.geoRegion,
        navigationElem = {
            elem: 'navigation-wrap',
            mix: [{ elem: 'row' }],
            content: {
                elem: 'navigation',
                mix: [{ elem: 'wrap' }, { block: 'i-clearfix' }],
                links: links,
                support: support,
                domains: domains,
                feedback: links.feedback
            }
        },
        res = [];

    // hero блок
    res.push({
        block: 'b-morda-hero',
        mods: { type: variant.toString() }, // DIRECT-60696 Эксперимент с мордами Директа
        mix: [
            { block: 'p-morda', elem: 'row' },
            { block: 'p-morda', elem: 'hero' }
        ],
        links: links,
        support: support
    });
    // promo
    res.push({
        elem: 'promo',
        mix: [
            { elem: 'row' },
            { elem: 'wrap' },
            { block: 'i-clearfix' }
        ],
        domains: domains
    });
    // видео
    videoSrc && res.push({
        elem: 'video',
        mix: [{ elem: 'row' }]
    });
    // навигация (страница без экспериментов)
    variant || res.push(navigationElem);
    // истории
    stories && stories.length && res.push({
        elem: 'stories',
        mix: [{ elem: 'row' }],
        content: {
            block: 'b-success-stories',
            stories: stories
        }
    });
    // новости и статистика
    res.push({
        elem: 'row',
        mix: [
            { elem: 'wrap' },
            { block: 'i-clearfix' }
        ],
        content: [
            {
                elem: 'news',
                content: news
            },
            showStatistics && {
                elem: 'statistics',
                geoRegion: geoRegion,
                links: links.social
            }
        ]
    });
    // блок "разместить рекламу"
    res.push({
        elem: 'bottom-links',
        content: {
            elem: 'wrap',
            content: [
                {
                    block: 'button2',
                    mix: [
                        {
                            block: 'p-morda',
                            elem: 'new-camp'
                        },
                        {
                            block: 'b-metrika',
                            js: {
                                goal: 'START_ADVERT1',
                                counter: '34'
                            }
                        },
                        {
                            block: 'b-metrika',
                            js: {
                                goal: 'START_ADVERT1',
                                counter: '191494'
                            }
                        }
                    ],
                    url: links.newCamp,
                    mods: {
                        theme: 'action',
                        type: 'link',
                        size: 'promo-l'
                    },
                    text: iget2('p-morda', 'start-advetising', 'Запустить рекламу')
                },
                !domains.tr && [
                    {
                        elem: 'bottom-or',
                        content: iget2('p-morda', 'ili', 'или')
                    }, {
                        elem: 'bottom-alternative-links',
                        links: links
                    }
                ]
            ]
        }
    });
    // навигация, если есть эксперимент
    if (variant) {
        res.push({ elem: 'separator' });
        res.push(navigationElem);
    }

    retargetingPixelLink && res.push({
        elem: 'retargeting',
        url: retargetingPixelLink
    });

    return res;
});

block('p-morda').elem('bottom-alternative-links')(

    content()(function() {
        var links = this.ctx.links;

        return {
            elem: 'pretty-banner',
            content: [
                iget2('p-morda', 'ask-help', 'Обратиться к {yandex} или {freelancer}', {
                    yandex: function(text) {
                        return {
                            elem: 'complex-btn',
                            content: [
                                {
                                    block: 'button2',
                                    mix: [
                                        { block: 'p-morda', elem: 'complex-btn', elemMods: { type: 'normal' } }
                                    ],
                                    mods: {
                                        theme: 'raised',
                                        type: 'link',
                                        size: 'm',
                                        pin: 'round-round'
                                    },
                                    target: '_blank',
                                    url: links.assistant,
                                    text: text
                                }, {
                                    block: 'button2',
                                    mix: [
                                        { block: 'p-morda', elem: 'complex-btn', elemMods: { type: 'active' } }
                                    ],
                                    mods: {
                                        theme: 'action',
                                        type: 'link',
                                        size: 'm',
                                        pin: 'round-round'
                                    },
                                    target: '_blank',
                                    url: links.assistant,
                                    text: text
                                }
                            ]
                        };
                    }(iget2('p-morda', 'ask-yandex', 'Сотруднику Яндекса')),

                    freelancer: function(text) {
                        return {
                            elem: 'complex-btn',
                            content: [
                                {
                                    block: 'button2',
                                    mix: [
                                        { block: 'p-morda', elem: 'complex-btn', elemMods: { type: 'normal' } }
                                    ],
                                    mods: {
                                        theme: 'raised',
                                        type: 'link',
                                        size: 'm',
                                        pin: 'round-round'
                                    },
                                    target: '_blank',
                                    url: links.freelancer,
                                    text: text
                                },
                                {
                                    block: 'button2',
                                    mix: [
                                        { block: 'p-morda', elem: 'complex-btn', elemMods: { type: 'active' } }
                                    ],
                                    mods: {
                                        theme: 'action',
                                        type: 'link',
                                        size: 'm',
                                        pin: 'round-round'
                                    },
                                    target: '_blank',
                                    url: links.freelancer,
                                    text: text
                                }
                            ]
                        };
                    }(iget2('p-morda', 'ask-freelancer', 'Частному специалисту'))
                }),
                {
                    elem: 'pretty-banner-image'
                }
            ]
        };
    })
);
