match(function() {
    return this.data.index_page;
})(

    block('app-main').mode('page-block')('p-morda'),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-morda', 'yandeks-direkt-kontekstnaya-reklama', 'Яндекс.Директ – контекстная реклама на Яндексе');
        }),

        elem('global-warning').replace()(''),

        elem('stat').mode('metrikaParams')(function() {
            var data = this.data,

                result = {
                    'yd.point_direct_face': true,
                    'yd.login': u.escapeHTML(this['i-global'].raw_login),
                    'yd.role': data.login_rights ? data.login_rights.role : '',
                    'yd.clientlogin': data.login_rights ? data.login_rights.client_chief_login : ''
                };

            if (data.has_text_camps == 0 && data.has_media_camps == 0) {
                result['yd.first'] = 'yes';
            }

            return result;
        }),
        //@see https://github.yandex-team.ru/direct/novocaine-lib/blob/master/services/request-data.js retpath
        elem('footer').replace()(function() {
            return {
                block: 'footer',
                retPath: this.data.cur_page
            };
        }),

        elem('static-js').replace()(function() {
            return [
                {
                    elem: 'js',
                    url: this.expandStaticFileName('/data3/desktop.bundles/morda/_morda.' + this.lang + '.js')
                }
            ];
        }),
        mode('static-css')(function() {
            return [
                {
                    elem: 'css',
                    url: this.expandStaticFileName('/data3/desktop.bundles/morda/_morda.css'),
                    ie: false
                },
                {
                    elem: 'css',
                    url: this.expandStaticFileName('/data3/desktop.bundles/morda/_morda.ie.css', 'union:desktop:ie'),
                    ie: 'IE'
                }
            ]
        })
    )
);

block('p-morda')(

    addJs()(function() {
        var videoSrc = apply('video'),
            data = this.data;

        return {
            videoSrc: videoSrc,
            needLogin: !(data.display_name || {}).name,
            defaultRetpath: u.consts('retpath')
        };
    }),

    mode('video')(function() {

        switch (this.data.lang) {
            case 'ru':
                return 'https://www.youtube-nocookie.com/embed/KNr--88uyR8?rel=0';
            case 'en':
                return 'https://video.yandex.ru/iframe/yacinema/jcvu3jsse3.2136/?hidden=rotate&hd=1&autoplay=1';
            case 'ua':
                return 'https://video.yandex.ru/iframe/yacinema/wgq2b65vax.1836/?hidden=rotate&hd=1&autoplay=1';
            case 'tr':
                return 'https://video.yandex.ru/iframe/yacinema/okcf6z4uw7.5236/?hidden=rotate&hd=1&autoplay=1';
        }
    }),

    match(function() { return !this.defTemplateProcessed; }).def()(function() {
        var data = this.data,
            domains = u.consts('domains'),
            yandexDomain = data.yandex_domain,
            urlObject = u.parseUrl(u.consts('SCRIPT')),
            newCampUrl = u.getUrl('advertize', {
                mediaType: 'text',
                touch: (data.FORM || {}).touch === '1' ? '1' : null,
                initCamp: '1'
            }),
            getMetrikaCountersMix = function(goal) {
                return [
                    {
                        block: 'b-metrika',
                        js: {
                            goals: [{
                                goal: goal,
                                counter: '191494'
                            }, {
                                goal: goal,
                                counter: '34'
                            }]
                        }
                    }
                ];
            },
            tld = u.consts('tld'),
            isBelarusClient = domains.by,
            isUkrClient = domains.ua,
            isKazClient = domains.kz;

        var officeCity;
        if (isBelarusClient) {
            officeCity = 'blr';
        }

        if (isUkrClient) {
            officeCity = 'ukr';
        }

        if (isKazClient) {
            officeCity = 'kaz';
        }

        if (!officeCity) {
            officeCity = this.data.officecity || 'other';
        }

        var clientServiceInfo = applyCtx({
                block: 'i-office-contacts',
                mods: {
                    type: 'morda'
                }
            })[officeCity],
            ctx = this.ctx;

        // DIRECT-60696 Эксперимент с мордами Директа
        ctx.variant = data.variant;
        ctx.links = (function() {

            var links = { // для всех
                instruments: [
                    {
                        title: iget2('p-morda', 'podbor-slov', 'Подбор слов'),
                        url: u.formatUrl({
                            protocol: 'https',
                            host: 'wordstat.' + yandexDomain,
                            query: {
                                direct: 1,
                                from: 'dirface14'
                            }
                        })
                    },
                    {
                        title: iget2('p-morda', 'prognoz-byudzheta', 'Прогноз бюджета'),
                        url: u.getUrl('advancedForecast'),
                        mix: [{
                            block: 'p-morda',
                            elem: 'advanced-forecast'
                        }]
                    },
                    {
                        title: iget2('p-morda', 'yandeks-metrika', 'Яндекс.Метрика'),
                        url: u.getMetrikaUrl('?from=dirface14')
                    },
                    {
                        title: iget2('p-morda', 'direkt-kommander', 'Директ Коммандер'),
                        url: u.formatUrl({
                            protocol: 'https',
                            host: urlObject.host,
                            path: 'commander/',
                            query: {
                                from: 'dirface14'
                            }
                        })
                    }
                ],
                help: [
                    {
                        title: iget2('p-morda', 'sposoby-oplaty', 'Способы оплаты'),
                        url: u.formatUrl({
                            protocol: 'https',
                            host: yandexDomain,
                            path: 'support/direct/payments/payment-methods.html'
                        })
                    },
                    !domains.tr && {
                        title: iget2('p-morda', 'onlayn-obuchenie', 'Онлайн-обучение'),
                        url: u.formatUrl({
                            protocol: 'https',
                            host: yandexDomain,
                            path: domains.com ? 'adv/edu/direct-start' : 'adv/edu/online/direct',
                            query: {
                                utm_source: 'direct',
                                utm_medium: 'main_promo',
                                utm_campaign: 'static'
                            }
                        })
                    }
                ],
                partners: [],
                social: [],
                feedback: u.getCommonHelpUrl('/direct/troubleshooting/start.xml'),
                newCamp: (data.display_name || {}).name ?
                    newCampUrl : u.formatUrl({
                        protocol: 'https',
                        host: 'passport.' + yandexDomain,
                        path: 'passport',
                        query: {
                            mode: 'auth',
                            retpath: encodeURIComponent(newCampUrl),
                            origin: 'direct'
                        }
                    }),
                freelancer: domains.com ?
                    'https://yandex.com/adv/contact/freelancers' :
                    '/dna/freelancers/',
                assistant: domains.com ?
                    'https://yandex.com/promo/adv/directsetupservice' :
                    'https://yandex.ru/promo/direct/freeservice?from=main',
                agency: u.formatUrl({
                    protocol: 'https',
                    host: yandexDomain,
                    path: '/adv/contact/agency',
                    query: !domains.tr && {
                        'services%5B%5D': 'direct'
                    }
                })
            };

            if (domains.tr) {
                /* открыть, когда выложат advertising.yandex.com.tr
                links.instruments.push({
                    title: iget('Экспертная поддержка'),
                    url: u.formatUrl({
                        protocol: 'http',
                        host: 'advertising.yandex.com.tr',
                        path: 'contact/order.xml'
                    })
                });
                */

                links.help.unshift({
                    title: iget2('p-morda', 'kak-razmestit-reklamu', 'Как разместить рекламу?'),
                    url: u.formatUrl({
                        protocol: 'https',
                        host: yandexDomain,
                        path: 'support/direct/quick-start/create-campaign.html'
                    })
                }, {
                    title: iget2('p-morda', 'kak-povysit-effektivnost-kampanii', 'Как повысить эффективность кампании?'),
                    url: u.formatUrl({
                        protocol: 'https',
                        host: yandexDomain,
                        path: 'support/direct/efficiency/improve-efficiency.html'
                    })
                }, {
                    title: iget2('p-morda', 'reklamnye-agentstva', 'Рекламные агентства'),
                    url: links.agency
                });

                return links;
            }

            links.help.push({
                title: iget2('p-morda', 'pomoshch-s-razmeshcheniem', 'Помощь с размещением'),
                url: links.assistant,
                mix: getMetrikaCountersMix('menu_help_personal_manager')
            }, {
                title: iget2('p-morda', 'reklamnye-agentstva', 'Рекламные агентства'),
                url: links.agency,
                mix: getMetrikaCountersMix('menu_help_agency')
            });

            links.partners.push({
                title: iget2('p-morda', 'agentstvam', 'Агентствам'),
                url: u.formatUrl({
                    protocol: 'https',
                    host: yandexDomain,
                    path: 'adv/partners'
                }),
                mix: getMetrikaCountersMix('menu_partner_agency')
            }, {
                title: iget2('p-morda', 'vladelcam-saytov', 'Владельцам сайтов'),
                url: u.formatUrl({
                    protocol: 'https',
                    host: domains.com ? 'partner2.yandex.com' : 'partner2.yandex.ru'
                }),
                mix: getMetrikaCountersMix('menu_partner_webmasters')
            });

            links.social.push({
                title: iget2('p-morda', 'how-business-use-us', 'Как бизнесы используют наши инструменты для продвижения'),
                url: u.formatUrl({
                    protocol: 'https',
                    host: yandexDomain,
                    path: 'adv/solutions/cases'
                })
            });

            if (domains.com) return links;

            links.help.unshift({
                title: iget2('p-morda', 'o-servise', 'О сервисе'),
                url: u.getCommonHelpUrl('/direct/')
            });

            return links;
        }).call(this);

        ctx.domains = domains;
        ctx.stories = (u['success-stories'].get() || [])
            .sort(function(a, b) {
                return new Date(b.date) - new Date(a.date);
            });
        ctx.news = applyCtx({
            block: 'b-news',
            news: data.news
        });

        //Для Украины, Белоруссии и Казахстана телефон поддержки для морды отличается от телефона поддержки в остальных местах
        //Историю странных взаимоотношений с Украиной читать здесь DIRECT-52723
        ctx.support = clientServiceInfo.supportMorda ?
            clientServiceInfo.supportMorda[0] :
            clientServiceInfo.support[0];

        ctx.videoSrc = apply('video');
        ctx.lang = data.lang === 'ua' ? 'uk' : data.lang;

        // скрываем блок с прогнозатором для com.tr
        ctx.showStatistics = !domains.tr;

        //@see DIRECT-39370
        if (tld === 'com' && !data.is_beta) {

            ctx.retargetingPixelLink = u.formatUrl({
                protocol: 'https',
                //Документ с пикселем должен запрашиваться с домена .net на котором нет куки
                host: data.no_cookies_domain,
                path: 'p-morda/__retargeting/p-morda__retargeting.html'
            });
        }

        ctx.uatraits = data.uatraits;

        ctx.geoRegion = data.geo_region;

        return applyNext({
            ctx: ctx,
            defTemplateProcessed: true
        });
    })
);
