block('p-multiedit2').elem('buttons-panel').content()(function() {
    var applied = applyNext(),
        ctx = this.ctx;

    if (applied) return applied;

    var buttons = {
        back: {
            block: 'button',
            mods: {
                disabled: ctx.disabled,
                size: 'm'
            },
            mix: [
                {
                    block: 'p-multiedit2',
                    mods: {
                        type: ctx.type
                    },
                    elem: 'back-button'
                },
                {
                    block: 'p-multiedit2',
                    elem: 'control-button'
                }
            ],
            content: iget2('p-multiedit2', 'nazad', 'Назад')
        },
        next: {
            block: 'button',
            mix: [
                {
                    block: 'p-multiedit2',
                    mods: {
                        type: ctx.type
                    },
                    elem: 'next-button'
                },
                {
                    block: 'p-multiedit2',
                    elem: 'control-button'
                }
            ],
            mods: {
                theme: 'action',
                disabled: ctx.disabled,
                size: 'm'
            },
            content: iget2('p-multiedit2', 'dalshe', 'Дальше')
        },
        submit: {
            block: 'button',
            mods: {
                theme: 'action',
                disabled: ctx.disabled,
                size: 'm'
            },
            mix: [
                {
                    block: 'p-multiedit2',
                    mods: {
                        type: ctx.type
                    },
                    elem: 'submit-button'
                },
                {
                    block: 'p-multiedit2',
                    elem: 'control-button'
                }
            ],
            content: this.ctx.isCampaignModerated ? iget2('p-multiedit2', 'otpravit-na-moderaciyu', 'Отправить на модерацию') : iget2('p-multiedit2', 'sohranit', 'Сохранить')
        },
        'to-draft': {
            block: 'button',
            mods: {
                disabled: ctx.disabled,
                size: 'm'
            },
            mix: [
                {
                    block: 'p-multiedit2',
                    mods: {
                        type: ctx.type
                    },
                    elem: 'to-draft'
                },
                {
                    block: 'p-multiedit2',
                    elem: 'control-button'
                }
            ],
            content: iget2('p-multiedit2', 'sohranit-v-chernovikah', 'Сохранить в черновиках')
        }
    };

    return [
        u.spacer2(this.ctx.buttons.filter(Boolean).map(function(button) {
            typeof button == 'string' && (button = { name: button });

            return u._.merge({}, buttons[button.name], u._.omit(button, 'name'), function(target, source) {
                // склеиваем в массив значения по пересекающимся ключам
                return target && source ? [].concat(target, source) : target;
            });
        }), '&nbsp;'),
        {
            elem: 'status-message',
            content: [
                {
                    block: 'spin',
                    js: { animation: 'sprite' },
                    mix: { block: 'p-multiedit2', elem: 'status-spin' },
                    mods: { theme: 'gray-16' }
                },
                {
                    elem: 'status-text',
                    content: iget2('p-multiedit2', 'vypolnyaetsya-sohranenie', 'Выполняется сохранение')
                }
            ]
        },
        this.ctx.hint
    ];

});
