 /**
  * Возвращает данные группы, существенные для ошибок
  * @param {Boolean} isSingleGroup
  */
block('p-multiedit2').elem('mass-actions').content()(function() {
    var campaign = this.data.campaign,
        clientId = campaign.ClientID,
        type = u.beminize(campaign.mediaType),
        isSingleGroup = this.ctx.isSingleGroup,
        isVisible = !isSingleGroup,
        bannerType = campaign.groups[0].cpm_banners_type;

    if (isSingleGroup) {
        isVisible = campaign.groups[0].banners.length > 1 &&
            bannerType !== 'cpm_outdoor' &&
            bannerType !== 'cpm_indoor';
    }

    return {
        block: 'l-page',
        elem: 'row',
        mix: [
            {
                block: 'b-edit-groups-mass-actions-toggle',
                elem: 'row',
                elemMods: {
                    visible: isVisible ? 'yes' : ''
                }
            }
        ],
        left: isSingleGroup ?
            true :
            {
                block: 'p-multiedit2',
                mods: {
                    type: type
                },
                elem: 'banner-groups-count',
                content: iget2('p-multiedit2', 'vybrano-s', 'Выбрано {foo}', {
                    foo: u.pluralize([iget2('p-multiedit2', 'gruppa', 'группа'), iget2('p-multiedit2', 'gruppy', 'группы'), iget2('p-multiedit2', 'grupp', 'групп')], campaign.groups.length)
                })
            },
        center: applyCtx({
            block: 'b-edit-groups-mass-actions-toggle',
            mods: {
                type: type,
                single: isSingleGroup ? 'yes' : 'no',
                visible: isVisible ? 'yes' : ''
            },
            clientId: clientId,
            isSingleGroup: isSingleGroup
        }),
        rgap: true,
        right: true
    };
});
